/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class EqualsAnyJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "equalsAny";
    public static final String FIELD_FIELD_PATH = "field";
    public static final String FIELD_VALUES = "values";
    public static final String FIELD_CASE_SENSITIVE = "caseSensitive";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("field", "values")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("caseSensitive")));
    private static final long serialVersionUID = -7441807169198186996L;
    private volatile boolean caseSensitive;
    private volatile List<JSONValue> values;
    private volatile List<String> field;

    EqualsAnyJSONObjectFilter() {
        this.field = null;
        this.values = null;
        this.caseSensitive = false;
    }

    private EqualsAnyJSONObjectFilter(List<String> field, List<JSONValue> values, boolean caseSensitive) {
        this.field = field;
        this.values = values;
        this.caseSensitive = caseSensitive;
    }

    public EqualsAnyJSONObjectFilter(String field, String ... values) {
        this(Collections.singletonList(field), EqualsAnyJSONObjectFilter.toJSONValues(values));
    }

    public EqualsAnyJSONObjectFilter(String field, JSONValue ... values) {
        this(Collections.singletonList(field), StaticUtils.toList(values));
    }

    public EqualsAnyJSONObjectFilter(String field, Collection<JSONValue> values) {
        this(Collections.singletonList(field), values);
    }

    public EqualsAnyJSONObjectFilter(List<String> field, Collection<JSONValue> values) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        Validator.ensureNotNull(values);
        Validator.ensureFalse(values.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        this.values = Collections.unmodifiableList(new ArrayList<JSONValue>(values));
        this.caseSensitive = false;
    }

    public List<String> getField() {
        return this.field;
    }

    public void setField(String ... field) {
        this.setField(StaticUtils.toList(field));
    }

    public void setField(List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
    }

    public List<JSONValue> getValues() {
        return this.values;
    }

    public void setValues(String ... values) {
        this.setValues(EqualsAnyJSONObjectFilter.toJSONValues(values));
    }

    public void setValues(JSONValue ... values) {
        this.setValues(StaticUtils.toList(values));
    }

    public void setValues(Collection<JSONValue> values) {
        Validator.ensureNotNull(values);
        Validator.ensureFalse(values.isEmpty());
        this.values = Collections.unmodifiableList(new ArrayList<JSONValue>(values));
    }

    private static List<JSONValue> toJSONValues(String ... values) {
        ArrayList<JSONValue> valueList = new ArrayList<JSONValue>(values.length);
        for (String s2 : values) {
            valueList.add(new JSONString(s2));
        }
        return valueList;
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        List<JSONValue> candidates = EqualsAnyJSONObjectFilter.getValues(o, this.field);
        if (candidates.isEmpty()) {
            return false;
        }
        for (JSONValue objectValue : candidates) {
            for (JSONValue filterValue : this.values) {
                if (!filterValue.equals(objectValue, false, !this.caseSensitive, false)) continue;
                return true;
            }
            if (!(objectValue instanceof JSONArray)) continue;
            JSONArray a = (JSONArray)objectValue;
            for (JSONValue filterValue : this.values) {
                if (!a.contains(filterValue, false, !this.caseSensitive, false, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(4));
        fields.put("filterType", new JSONString(FILTER_TYPE));
        if (this.field.size() == 1) {
            fields.put(FIELD_FIELD_PATH, new JSONString(this.field.get(0)));
        } else {
            ArrayList<JSONString> fieldNameValues = new ArrayList<JSONString>(this.field.size());
            for (String s2 : this.field) {
                fieldNameValues.add(new JSONString(s2));
            }
            fields.put(FIELD_FIELD_PATH, new JSONArray(fieldNameValues));
        }
        fields.put(FIELD_VALUES, new JSONArray(this.values));
        if (this.caseSensitive) {
            fields.put(FIELD_CASE_SENSITIVE, JSONBoolean.TRUE);
        }
        return new JSONObject(fields);
    }

    @Override
    protected EqualsAnyJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        List<String> fieldPath = this.getStrings(filterObject, FIELD_FIELD_PATH, false, null);
        boolean isCaseSensitive = this.getBoolean(filterObject, FIELD_CASE_SENSITIVE, false);
        JSONValue arrayValue = filterObject.getField(FIELD_VALUES);
        if (arrayValue instanceof JSONArray) {
            return new EqualsAnyJSONObjectFilter(fieldPath, ((JSONArray)arrayValue).getValues(), isCaseSensitive);
        }
        throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_ARRAY.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_VALUES));
    }
}

