/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogBatchChangeSelectionCriteria;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AnyAttributesChangeSelectionCriteria
extends ChangelogBatchChangeSelectionCriteria {
    static final byte TYPE_SELECTION_CRITERIA_ANY_ATTRIBUTES = -95;
    private final List<String> attributeNames;

    public AnyAttributesChangeSelectionCriteria(String ... attributeNames) {
        this(StaticUtils.toList(attributeNames));
    }

    public AnyAttributesChangeSelectionCriteria(Collection<String> attributeNames) {
        Validator.ensureNotNull(attributeNames);
        Validator.ensureFalse(attributeNames.isEmpty());
        this.attributeNames = Collections.unmodifiableList(new ArrayList<String>(attributeNames));
    }

    static AnyAttributesChangeSelectionCriteria decodeInnerElement(ASN1Element innerElement) throws LDAPException {
        try {
            ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(innerElement).elements();
            ArrayList<String> attrNames = new ArrayList<String>(attrElements.length);
            for (ASN1Element e : attrElements) {
                attrNames.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
            }
            return new AnyAttributesChangeSelectionCriteria(attrNames);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_ANY_ATTRS_CHANGE_SELECTION_CRITERIA_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public ASN1Element encodeInnerElement() {
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(this.attributeNames.size());
        for (String s2 : this.attributeNames) {
            elements.add(new ASN1OctetString(s2));
        }
        return new ASN1Sequence(-95, elements);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AnyAttributesChangeSelectionCriteria(attributeNames={");
        Iterator<String> iterator = this.attributeNames.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

