/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateClientResponseValue
implements Serializable {
    private static final byte TYPE_UPSTREAM_RESPONSE = -96;
    private static final byte TYPE_UPSTREAM_SERVER_ADDRESS = -127;
    private static final byte TYPE_UPSTREAM_SERVER_SECURE = -126;
    private static final byte TYPE_SERVER_NAME = -125;
    private static final byte TYPE_SERVER_SESSION_ID = -124;
    private static final byte TYPE_SERVER_RESPONSE_ID = -123;
    private static final long serialVersionUID = 5165171788442351399L;
    private final Boolean upstreamServerSecure;
    private final IntermediateClientResponseValue upstreamResponse;
    private final String serverName;
    private final String serverResponseID;
    private final String serverSessionID;
    private final String upstreamServerAddress;

    public IntermediateClientResponseValue(IntermediateClientResponseValue upstreamResponse, String upstreamServerAddress, Boolean upstreamServerSecure, String serverName, String serverSessionID, String serverResponseID) {
        this.upstreamResponse = upstreamResponse;
        this.upstreamServerAddress = upstreamServerAddress;
        this.upstreamServerSecure = upstreamServerSecure;
        this.serverName = serverName;
        this.serverSessionID = serverSessionID;
        this.serverResponseID = serverResponseID;
    }

    public IntermediateClientResponseValue getUpstreamResponse() {
        return this.upstreamResponse;
    }

    public String getUpstreamServerAddress() {
        return this.upstreamServerAddress;
    }

    public Boolean upstreamServerSecure() {
        return this.upstreamServerSecure;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerSessionID() {
        return this.serverSessionID;
    }

    public String getServerResponseID() {
        return this.serverResponseID;
    }

    public ASN1Sequence encode() {
        return this.encode((byte)48);
    }

    private ASN1Sequence encode(byte type) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(6);
        if (this.upstreamResponse != null) {
            elements.add(this.upstreamResponse.encode((byte)-96));
        }
        if (this.upstreamServerAddress != null) {
            elements.add(new ASN1OctetString(-127, this.upstreamServerAddress));
        }
        if (this.upstreamServerSecure != null) {
            elements.add(new ASN1Boolean(-126, this.upstreamServerSecure));
        }
        if (this.serverName != null) {
            elements.add(new ASN1OctetString(-125, this.serverName));
        }
        if (this.serverSessionID != null) {
            elements.add(new ASN1OctetString(-124, this.serverSessionID));
        }
        if (this.serverResponseID != null) {
            elements.add(new ASN1OctetString(-123, this.serverResponseID));
        }
        return new ASN1Sequence(type, elements);
    }

    public static IntermediateClientResponseValue decode(ASN1Sequence sequence) throws LDAPException {
        Boolean upstreamServerSecure = null;
        IntermediateClientResponseValue upstreamResponse = null;
        String upstreamServerAddress = null;
        String serverName = null;
        String serverResponseID = null;
        String serverSessionID = null;
        block13: for (ASN1Element element : sequence.elements()) {
            switch (element.getType()) {
                case -96: {
                    try {
                        ASN1Sequence s2 = ASN1Sequence.decodeAsSequence(element);
                        upstreamResponse = IntermediateClientResponseValue.decode(s2);
                        continue block13;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_CANNOT_DECODE_UPSTREAM_RESPONSE.get(le.getMessage()), le);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_CANNOT_DECODE_UPSTREAM_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                case -127: {
                    upstreamServerAddress = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block13;
                }
                case -126: {
                    try {
                        upstreamServerSecure = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                        continue block13;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_CANNOT_DECODE_UPSTREAM_SECURE.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                case -125: {
                    serverName = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block13;
                }
                case -124: {
                    serverSessionID = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block13;
                }
                case -123: {
                    serverResponseID = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block13;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(element.getType())));
                }
            }
        }
        return new IntermediateClientResponseValue(upstreamResponse, upstreamServerAddress, upstreamServerSecure, serverName, serverSessionID, serverResponseID);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.upstreamResponse != null) {
            hashCode += this.upstreamResponse.hashCode();
        }
        if (this.upstreamServerAddress != null) {
            hashCode += this.upstreamServerAddress.hashCode();
        }
        if (this.upstreamServerSecure != null) {
            hashCode += this.upstreamServerSecure.hashCode();
        }
        if (this.serverName != null) {
            hashCode += this.serverName.hashCode();
        }
        if (this.serverSessionID != null) {
            hashCode += this.serverSessionID.hashCode();
        }
        if (this.serverResponseID != null) {
            hashCode += this.serverResponseID.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof IntermediateClientResponseValue)) {
            return false;
        }
        IntermediateClientResponseValue v = (IntermediateClientResponseValue)o;
        if (this.upstreamResponse == null ? v.upstreamResponse != null : !this.upstreamResponse.equals(v.upstreamResponse)) {
            return false;
        }
        if (this.upstreamServerAddress == null ? v.upstreamServerAddress != null : !this.upstreamServerAddress.equals(v.upstreamServerAddress)) {
            return false;
        }
        if (this.upstreamServerSecure == null ? v.upstreamServerSecure != null : !this.upstreamServerSecure.equals(v.upstreamServerSecure)) {
            return false;
        }
        if (this.serverName == null ? v.serverName != null : !this.serverName.equals(v.serverName)) {
            return false;
        }
        if (this.serverSessionID == null ? v.serverSessionID != null : !this.serverSessionID.equals(v.serverSessionID)) {
            return false;
        }
        return !(this.serverResponseID == null ? v.serverResponseID != null : !this.serverResponseID.equals(v.serverResponseID));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("IntermediateClientResponseValue(");
        boolean added = false;
        if (this.upstreamResponse != null) {
            buffer.append("upstreamResponse=");
            this.upstreamResponse.toString(buffer);
            added = true;
        }
        if (this.upstreamServerAddress != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("upstreamServerAddress='");
            buffer.append(this.upstreamServerAddress);
            buffer.append('\'');
        }
        if (this.upstreamServerSecure != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("upstreamServerSecure='");
            buffer.append(this.upstreamServerSecure);
            buffer.append('\'');
        }
        if (this.serverName != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("serverName='");
            buffer.append(this.serverName);
            buffer.append('\'');
        }
        if (this.serverSessionID != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("serverSessionID='");
            buffer.append(this.serverSessionID);
            buffer.append('\'');
        }
        if (this.serverResponseID != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("serverResponseID='");
            buffer.append(this.serverResponseID);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

