/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetAuthorizationEntryRequestControl
extends Control {
    public static final String GET_AUTHORIZATION_ENTRY_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.6";
    private static final byte TYPE_INCLUDE_AUTHN_ENTRY = -128;
    private static final byte TYPE_INCLUDE_AUTHZ_ENTRY = -127;
    private static final byte TYPE_ATTRIBUTES = -94;
    private static final long serialVersionUID = -5540345171260624216L;
    private final boolean includeAuthNEntry;
    private final boolean includeAuthZEntry;
    private final List<String> attributes;

    public GetAuthorizationEntryRequestControl() {
        this(false, true, true, (List<String>)null);
    }

    public GetAuthorizationEntryRequestControl(boolean includeAuthNEntry, boolean includeAuthZEntry, String ... attributes) {
        this(false, includeAuthNEntry, includeAuthZEntry, attributes == null ? null : Arrays.asList(attributes));
    }

    public GetAuthorizationEntryRequestControl(boolean includeAuthNEntry, boolean includeAuthZEntry, List<String> attributes) {
        this(false, includeAuthNEntry, includeAuthZEntry, attributes);
    }

    public GetAuthorizationEntryRequestControl(boolean isCritical, boolean includeAuthNEntry, boolean includeAuthZEntry, String ... attributes) {
        this(isCritical, includeAuthNEntry, includeAuthZEntry, attributes == null ? null : Arrays.asList(attributes));
    }

    public GetAuthorizationEntryRequestControl(boolean isCritical, boolean includeAuthNEntry, boolean includeAuthZEntry, List<String> attributes) {
        super(GET_AUTHORIZATION_ENTRY_REQUEST_OID, isCritical, GetAuthorizationEntryRequestControl.encodeValue(includeAuthNEntry, includeAuthZEntry, attributes));
        this.includeAuthNEntry = includeAuthNEntry;
        this.includeAuthZEntry = includeAuthZEntry;
        this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(attributes));
    }

    public GetAuthorizationEntryRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            this.includeAuthNEntry = true;
            this.includeAuthZEntry = true;
            this.attributes = Collections.emptyList();
            return;
        }
        try {
            ArrayList<String> attrs = new ArrayList<String>(20);
            boolean includeAuthN = true;
            boolean includeAuthZ = true;
            ASN1Element element = ASN1Element.decode(value.getValue());
            block8: for (ASN1Element e : ASN1Sequence.decodeAsSequence(element).elements()) {
                switch (e.getType()) {
                    case -128: {
                        includeAuthN = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -127: {
                        includeAuthZ = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -94: {
                        for (ASN1Element ae : ASN1Sequence.decodeAsSequence(e).elements()) {
                            attrs.add(ASN1OctetString.decodeAsOctetString(ae).stringValue());
                        }
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_INVALID_SEQUENCE_ELEMENT.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.includeAuthNEntry = includeAuthN;
            this.includeAuthZEntry = includeAuthZ;
            this.attributes = attrs;
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(boolean includeAuthNEntry, boolean includeAuthZEntry, List<String> attributes) {
        if (includeAuthNEntry && includeAuthZEntry && (attributes == null || attributes.isEmpty())) {
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        if (!includeAuthNEntry) {
            elements.add(new ASN1Boolean(-128, false));
        }
        if (!includeAuthZEntry) {
            elements.add(new ASN1Boolean(-127, false));
        }
        if (attributes != null && !attributes.isEmpty()) {
            ArrayList<ASN1OctetString> attrElements = new ArrayList<ASN1OctetString>(attributes.size());
            for (String s2 : attributes) {
                attrElements.add(new ASN1OctetString(s2));
            }
            elements.add(new ASN1Sequence(-94, attrElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public boolean includeAuthNEntry() {
        return this.includeAuthNEntry;
    }

    public boolean includeAuthZEntry() {
        return this.includeAuthZEntry;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_AUTHORIZATION_ENTRY_REQUEST.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GetAuthorizationEntryRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", includeAuthNEntry=");
        buffer.append(this.includeAuthNEntry);
        buffer.append(", includeAuthZEntry=");
        buffer.append(this.includeAuthZEntry);
        buffer.append(", attributes={");
        Iterator<String> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

