/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.matchingrules.BooleanMatchingRule;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.GeneralizedTimeMatchingRule;
import com.unboundid.ldap.matchingrules.IntegerMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.NumericStringMatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.matchingrules.TelephoneNumberMatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.transformations.LDIFChangeRecordTransformation;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadLocalRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ScrambleAttributeTransformation
implements EntryTransformation,
LDIFChangeRecordTransformation {
    private static final char[] ASCII_DIGITS = "0123456789".toCharArray();
    private static final char[] ASCII_SYMBOLS = " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".toCharArray();
    private static final char[] LOWERCASE_ASCII_LETTERS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] UPPERCASE_ASCII_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final long MILLIS_PER_DAY = 86400000L;
    private final boolean scrambleEntryDNs;
    private final long randomSeed;
    private final long createTime = System.currentTimeMillis();
    private final Schema schema;
    private final Map<String, MatchingRule> attributes;
    private final Set<String> jsonFields;
    private final ThreadLocal<Random> randoms = new ThreadLocal();

    public ScrambleAttributeTransformation(String ... attributes) {
        this((Schema)null, (Long)null, attributes);
    }

    public ScrambleAttributeTransformation(Collection<String> attributes) {
        this(null, null, false, attributes, null);
    }

    public ScrambleAttributeTransformation(Schema schema, Long randomSeed, String ... attributes) {
        this(schema, randomSeed, false, StaticUtils.toList(attributes), null);
    }

    public ScrambleAttributeTransformation(Schema schema, Long randomSeed, boolean scrambleEntryDNs, Collection<String> attributes, Collection<String> jsonFields) {
        this.scrambleEntryDNs = scrambleEntryDNs;
        this.randomSeed = randomSeed == null ? ThreadLocalRandom.get().nextLong() : randomSeed.longValue();
        Schema s2 = schema;
        if (s2 == null) {
            try {
                s2 = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s2;
        HashMap<String, MatchingRule> m3 = new HashMap<String, MatchingRule>(StaticUtils.computeMapCapacity(10));
        for (String a : attributes) {
            String baseName = StaticUtils.toLowerCase(Attribute.getBaseName(a));
            AttributeTypeDefinition at = null;
            if (schema != null) {
                at = schema.getAttributeType(baseName);
            }
            if (at == null) {
                m3.put(baseName, CaseIgnoreStringMatchingRule.getInstance());
                continue;
            }
            MatchingRule mr = MatchingRule.selectEqualityMatchingRule(baseName, schema);
            m3.put(StaticUtils.toLowerCase(at.getOID()), mr);
            for (String attrName : at.getNames()) {
                m3.put(StaticUtils.toLowerCase(attrName), mr);
            }
        }
        this.attributes = Collections.unmodifiableMap(m3);
        if (jsonFields == null) {
            this.jsonFields = Collections.emptySet();
        } else {
            HashSet<String> fieldNames = new HashSet<String>(StaticUtils.computeMapCapacity(jsonFields.size()));
            for (String fieldName : jsonFields) {
                fieldNames.add(StaticUtils.toLowerCase(fieldName));
            }
            this.jsonFields = Collections.unmodifiableSet(fieldNames);
        }
    }

    @Override
    public Entry transformEntry(Entry e) {
        if (e == null) {
            return null;
        }
        String dn = this.scrambleEntryDNs ? this.scrambleDN(e.getDN()) : e.getDN();
        Collection<Attribute> originalAttributes = e.getAttributes();
        ArrayList<Attribute> scrambledAttributes = new ArrayList<Attribute>(originalAttributes.size());
        for (Attribute a : originalAttributes) {
            scrambledAttributes.add(this.scrambleAttribute(a));
        }
        return new Entry(dn, this.schema, scrambledAttributes);
    }

    @Override
    public LDIFChangeRecord transformChangeRecord(LDIFChangeRecord r) {
        if (r == null) {
            return null;
        }
        if (r instanceof LDIFAddChangeRecord) {
            LDIFAddChangeRecord addRecord = (LDIFAddChangeRecord)r;
            return new LDIFAddChangeRecord(this.transformEntry(addRecord.getEntryToAdd()), addRecord.getControls());
        }
        if (r instanceof LDIFDeleteChangeRecord) {
            if (this.scrambleEntryDNs) {
                return new LDIFDeleteChangeRecord(this.scrambleDN(r.getDN()), r.getControls());
            }
            return r;
        }
        if (r instanceof LDIFModifyChangeRecord) {
            LDIFModifyChangeRecord modifyRecord = (LDIFModifyChangeRecord)r;
            Modification[] originalMods = modifyRecord.getModifications();
            Modification[] newMods = new Modification[originalMods.length];
            for (int i = 0; i < originalMods.length; ++i) {
                Modification m3 = originalMods[i];
                if (!m3.hasValue()) {
                    newMods[i] = m3;
                    continue;
                }
                String attrName = StaticUtils.toLowerCase(Attribute.getBaseName(m3.getAttributeName()));
                if (!this.attributes.containsKey(attrName)) {
                    newMods[i] = m3;
                    continue;
                }
                Attribute scrambledAttribute = this.scrambleAttribute(m3.getAttribute());
                newMods[i] = new Modification(m3.getModificationType(), m3.getAttributeName(), scrambledAttribute.getRawValues());
            }
            if (this.scrambleEntryDNs) {
                return new LDIFModifyChangeRecord(this.scrambleDN(modifyRecord.getDN()), newMods, modifyRecord.getControls());
            }
            return new LDIFModifyChangeRecord(modifyRecord.getDN(), newMods, modifyRecord.getControls());
        }
        if (r instanceof LDIFModifyDNChangeRecord) {
            if (this.scrambleEntryDNs) {
                LDIFModifyDNChangeRecord modDNRecord = (LDIFModifyDNChangeRecord)r;
                return new LDIFModifyDNChangeRecord(this.scrambleDN(modDNRecord.getDN()), this.scrambleDN(modDNRecord.getNewRDN()), modDNRecord.deleteOldRDN(), this.scrambleDN(modDNRecord.getNewSuperiorDN()), modDNRecord.getControls());
            }
            return r;
        }
        return r;
    }

    public String scrambleDN(String dn) {
        if (dn == null) {
            return null;
        }
        try {
            return this.scrambleDN(new DN(dn)).toString();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return dn;
        }
    }

    public DN scrambleDN(DN dn) {
        if (dn == null || dn.isNullDN()) {
            return dn;
        }
        boolean changeApplied = false;
        RDN[] originalRDNs = dn.getRDNs();
        RDN[] scrambledRDNs = new RDN[originalRDNs.length];
        for (int i = 0; i < originalRDNs.length; ++i) {
            scrambledRDNs[i] = this.scrambleRDN(originalRDNs[i]);
            if (scrambledRDNs[i] == originalRDNs[i]) continue;
            changeApplied = true;
        }
        if (changeApplied) {
            return new DN(scrambledRDNs);
        }
        return dn;
    }

    public RDN scrambleRDN(RDN rdn) {
        String[] names;
        boolean changeRequired = false;
        for (String s2 : names = rdn.getAttributeNames()) {
            String lowerBaseName = StaticUtils.toLowerCase(Attribute.getBaseName(s2));
            if (!this.attributes.containsKey(lowerBaseName)) continue;
            changeRequired = true;
            break;
        }
        if (!changeRequired) {
            return rdn;
        }
        Attribute[] originalAttrs = rdn.getAttributes();
        byte[][] scrambledValues = new byte[originalAttrs.length][];
        for (int i = 0; i < originalAttrs.length; ++i) {
            scrambledValues[i] = this.scrambleAttribute(originalAttrs[i]).getValueByteArray();
        }
        return new RDN(names, scrambledValues, this.schema);
    }

    public Attribute scrambleAttribute(Attribute a) {
        if (a == null || a.size() == 0) {
            return a;
        }
        String baseName = StaticUtils.toLowerCase(a.getBaseName());
        MatchingRule matchingRule = this.attributes.get(baseName);
        if (matchingRule == null) {
            return a;
        }
        if (matchingRule instanceof BooleanMatchingRule) {
            if (a.size() == 1) {
                return new Attribute(a.getName(), this.schema, ThreadLocalRandom.get().nextBoolean() ? "TRUE" : "FALSE");
            }
            return new Attribute(a.getName(), this.schema, "TRUE", "FALSE");
        }
        if (matchingRule instanceof DistinguishedNameMatchingRule) {
            String[] originalValues = a.getValues();
            String[] scrambledValues = new String[originalValues.length];
            for (int i = 0; i < originalValues.length; ++i) {
                try {
                    scrambledValues[i] = this.scrambleDN(new DN(originalValues[i])).toString();
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    scrambledValues[i] = this.scrambleString(originalValues[i]);
                }
            }
            return new Attribute(a.getName(), this.schema, scrambledValues);
        }
        if (matchingRule instanceof GeneralizedTimeMatchingRule) {
            String[] originalValues = a.getValues();
            String[] scrambledValues = new String[originalValues.length];
            for (int i = 0; i < originalValues.length; ++i) {
                scrambledValues[i] = this.scrambleGeneralizedTime(originalValues[i]);
            }
            return new Attribute(a.getName(), this.schema, scrambledValues);
        }
        if (matchingRule instanceof IntegerMatchingRule || matchingRule instanceof NumericStringMatchingRule || matchingRule instanceof TelephoneNumberMatchingRule) {
            String[] originalValues = a.getValues();
            String[] scrambledValues = new String[originalValues.length];
            for (int i = 0; i < originalValues.length; ++i) {
                scrambledValues[i] = this.scrambleNumericValue(originalValues[i]);
            }
            return new Attribute(a.getName(), this.schema, scrambledValues);
        }
        if (matchingRule instanceof OctetStringMatchingRule) {
            byte[][] originalValues = a.getValueByteArrays();
            byte[][] scrambledValues = new byte[originalValues.length][];
            for (int i = 0; i < originalValues.length; ++i) {
                scrambledValues[i] = baseName.equals("userpassword") || baseName.equals("2.5.4.35") ? StaticUtils.getBytes(this.scrambleEncodedPassword(StaticUtils.toUTF8String(originalValues[i]))) : this.scrambleBinaryValue(originalValues[i]);
            }
            return new Attribute(a.getName(), this.schema, (byte[][])scrambledValues);
        }
        String[] originalValues = a.getValues();
        String[] scrambledValues = new String[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            scrambledValues[i] = baseName.equals("userpassword") || baseName.equals("2.5.4.35") || baseName.equals("authpassword") || baseName.equals("1.3.6.1.4.1.4203.1.3.4") ? this.scrambleEncodedPassword(originalValues[i]) : (originalValues[i].startsWith("{") && originalValues[i].endsWith("}") ? this.scrambleJSONObject(originalValues[i]) : this.scrambleString(originalValues[i]));
        }
        return new Attribute(a.getName(), this.schema, scrambledValues);
    }

    public String scrambleGeneralizedTime(String s2) {
        long decodedTime;
        if (s2 == null) {
            return null;
        }
        Random random = this.getRandom(s2);
        try {
            decodedTime = StaticUtils.decodeGeneralizedTime(s2).getTime();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return this.scrambleString(s2);
        }
        long timeSpan = Math.abs(this.createTime - decodedTime);
        if (timeSpan < 86400000L) {
            timeSpan += 86400000L;
        }
        long randomLong = random.nextLong() & Long.MAX_VALUE;
        long randomOffset = randomLong % (timeSpan *= 2L);
        long randomTime = decodedTime > this.createTime ? this.createTime + randomOffset : this.createTime - randomOffset;
        String generalizedTime = StaticUtils.encodeGeneralizedTime(randomTime);
        boolean stillInGeneralizedTime = true;
        StringBuilder scrambledValue = new StringBuilder(s2.length());
        for (int i = 0; i < s2.length(); ++i) {
            char originalCharacter = s2.charAt(i);
            if (stillInGeneralizedTime) {
                if (i < generalizedTime.length() && originalCharacter >= '0' && originalCharacter <= '9') {
                    char generalizedTimeCharacter = generalizedTime.charAt(i);
                    if (generalizedTimeCharacter >= '0' && generalizedTimeCharacter <= '9') {
                        scrambledValue.append(generalizedTimeCharacter);
                        continue;
                    }
                    scrambledValue.append(originalCharacter);
                    if (generalizedTimeCharacter == '.') continue;
                    stillInGeneralizedTime = false;
                    continue;
                }
                scrambledValue.append(originalCharacter);
                if (originalCharacter == '.') continue;
                stillInGeneralizedTime = false;
                continue;
            }
            scrambledValue.append(originalCharacter);
        }
        return scrambledValue.toString();
    }

    public String scrambleNumericValue(String s2) {
        if (s2 == null) {
            return null;
        }
        int firstDigitPos = -1;
        boolean multipleDigits = false;
        char[] chars = s2.toCharArray();
        Random random = this.getRandom(s2);
        StringBuilder scrambledValue = new StringBuilder(s2.length());
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '0' && c <= '9') {
                scrambledValue.append(random.nextInt(10));
                if (firstDigitPos < 0) {
                    firstDigitPos = i;
                    continue;
                }
                multipleDigits = true;
                continue;
            }
            scrambledValue.append(c);
        }
        if (firstDigitPos < 0) {
            return this.scrambleString(s2);
        }
        if (multipleDigits && scrambledValue.charAt(firstDigitPos) == '0') {
            scrambledValue.setCharAt(firstDigitPos, (char)(random.nextInt(9) + 49));
        }
        return scrambledValue.toString();
    }

    public byte[] scrambleBinaryValue(byte[] value) {
        if (value == null) {
            return null;
        }
        Random random = this.getRandom(value);
        byte[] scrambledValue = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            byte b = value[i];
            scrambledValue[i] = b >= 97 && b <= 122 ? (byte)ScrambleAttributeTransformation.randomCharacter(LOWERCASE_ASCII_LETTERS, random) : (b >= 65 && b <= 90 ? (byte)ScrambleAttributeTransformation.randomCharacter(UPPERCASE_ASCII_LETTERS, random) : (b >= 48 && b <= 57 ? (byte)ScrambleAttributeTransformation.randomCharacter(ASCII_DIGITS, random) : (b >= 32 && b <= 126 ? (byte)ScrambleAttributeTransformation.randomCharacter(ASCII_SYMBOLS, random) : ((b & 0x80) == 0 ? (byte)(random.nextInt(95) + 32) : (byte)(random.nextInt() & 0xFF | 0x80)))));
        }
        return scrambledValue;
    }

    public String scrambleEncodedPassword(String s2) {
        int secondDollarPos;
        if (s2 == null) {
            return null;
        }
        int closeBracePos = s2.indexOf(125);
        if (s2.startsWith("{") && closeBracePos > 0 && closeBracePos < s2.length() - 1) {
            return s2.substring(0, closeBracePos + 1) + this.scrambleString(s2.substring(closeBracePos + 1));
        }
        int firstDollarPos = s2.indexOf(36);
        if (firstDollarPos > 0 && (secondDollarPos = s2.indexOf(36, firstDollarPos + 1)) > 0) {
            return s2.substring(0, firstDollarPos + 1) + this.scrambleString(s2.substring(firstDollarPos + 1));
        }
        return this.scrambleString(s2);
    }

    public String scrambleJSONObject(String s2) {
        JSONObject o;
        if (s2 == null) {
            return null;
        }
        try {
            o = new JSONObject(s2);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return this.scrambleString(s2);
        }
        boolean scrambleAllFields = this.jsonFields.isEmpty();
        Map<String, JSONValue> originalFields = o.getFields();
        LinkedHashMap<String, JSONValue> scrambledFields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(originalFields.size()));
        for (Map.Entry<String, JSONValue> e : originalFields.entrySet()) {
            String fieldName = e.getKey();
            JSONValue originalValue = e.getValue();
            JSONValue scrambledValue = scrambleAllFields || this.jsonFields.contains(StaticUtils.toLowerCase(fieldName)) ? this.scrambleJSONValue(originalValue, true) : (originalValue instanceof JSONArray ? this.scrambleObjectsInArray((JSONArray)originalValue) : (originalValue instanceof JSONObject ? this.scrambleJSONValue(originalValue, false) : originalValue));
            scrambledFields.put(fieldName, scrambledValue);
        }
        return new JSONObject(scrambledFields).toString();
    }

    private JSONValue scrambleJSONValue(JSONValue v, boolean scrambleAllFields) {
        if (v instanceof JSONArray) {
            JSONArray a = (JSONArray)v;
            List<JSONValue> originalValues = a.getValues();
            ArrayList<JSONValue> scrambledValues = new ArrayList<JSONValue>(originalValues.size());
            for (JSONValue arrayValue : originalValues) {
                scrambledValues.add(this.scrambleJSONValue(arrayValue, true));
            }
            return new JSONArray(scrambledValues);
        }
        if (v instanceof JSONBoolean) {
            return new JSONBoolean(ThreadLocalRandom.get().nextBoolean());
        }
        if (v instanceof JSONNumber) {
            try {
                return new JSONNumber(this.scrambleNumericValue(v.toString()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                return v;
            }
        }
        if (v instanceof JSONObject) {
            JSONObject o = (JSONObject)v;
            Map<String, JSONValue> originalFields = o.getFields();
            LinkedHashMap<String, JSONValue> scrambledFields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(originalFields.size()));
            for (Map.Entry<String, JSONValue> e : originalFields.entrySet()) {
                String fieldName = e.getKey();
                JSONValue originalValue = e.getValue();
                JSONValue scrambledValue = scrambleAllFields || this.jsonFields.contains(StaticUtils.toLowerCase(fieldName)) ? this.scrambleJSONValue(originalValue, scrambleAllFields) : (originalValue instanceof JSONArray ? this.scrambleObjectsInArray((JSONArray)originalValue) : (originalValue instanceof JSONObject ? this.scrambleJSONValue(originalValue, false) : originalValue));
                scrambledFields.put(fieldName, scrambledValue);
            }
            return new JSONObject(scrambledFields);
        }
        if (v instanceof JSONString) {
            JSONString s2 = (JSONString)v;
            return new JSONString(this.scrambleString(s2.stringValue()));
        }
        return v;
    }

    private JSONArray scrambleObjectsInArray(JSONArray a) {
        List<JSONValue> originalValues = a.getValues();
        ArrayList<JSONValue> scrambledValues = new ArrayList<JSONValue>(originalValues.size());
        for (JSONValue arrayValue : originalValues) {
            if (arrayValue instanceof JSONArray) {
                scrambledValues.add(this.scrambleObjectsInArray((JSONArray)arrayValue));
                continue;
            }
            if (arrayValue instanceof JSONObject) {
                scrambledValues.add(this.scrambleJSONValue(arrayValue, false));
                continue;
            }
            scrambledValues.add(arrayValue);
        }
        return new JSONArray(scrambledValues);
    }

    public String scrambleString(String s2) {
        if (s2 == null) {
            return null;
        }
        Random random = this.getRandom(s2);
        StringBuilder scrambledString = new StringBuilder(s2.length());
        for (char c : s2.toCharArray()) {
            if (c >= 'a' && c <= 'z') {
                scrambledString.append(ScrambleAttributeTransformation.randomCharacter(LOWERCASE_ASCII_LETTERS, random));
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                scrambledString.append(ScrambleAttributeTransformation.randomCharacter(UPPERCASE_ASCII_LETTERS, random));
                continue;
            }
            if (c >= '0' && c <= '9') {
                scrambledString.append(ScrambleAttributeTransformation.randomCharacter(ASCII_DIGITS, random));
                continue;
            }
            scrambledString.append(c);
        }
        return scrambledString.toString();
    }

    private static char randomCharacter(char[] set, Random r) {
        return set[r.nextInt(set.length)];
    }

    private Random getRandom(String value) {
        Random r = this.randoms.get();
        if (r == null) {
            r = new Random(this.randomSeed + (long)value.hashCode());
            this.randoms.set(r);
        } else {
            r.setSeed(this.randomSeed + (long)value.hashCode());
        }
        return r;
    }

    private Random getRandom(byte[] value) {
        Random r = this.randoms.get();
        if (r == null) {
            r = new Random(this.randomSeed + (long)Arrays.hashCode(value));
            this.randoms.set(r);
        } else {
            r.setSeed(this.randomSeed + (long)Arrays.hashCode(value));
        }
        return r;
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public LDIFChangeRecord translate(LDIFChangeRecord original, long firstLineNumber) {
        return this.transformChangeRecord(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }

    @Override
    public LDIFChangeRecord translateChangeRecordToWrite(LDIFChangeRecord original) {
        return this.transformChangeRecord(original);
    }
}

