/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplaceAttributeTransformation
implements EntryTransformation {
    private final Schema schema;
    private final Map<String, Attribute> attributes;

    public ReplaceAttributeTransformation(Schema schema, String attributeName, String ... newValues) {
        this(schema, new Attribute(attributeName, schema, newValues));
    }

    public ReplaceAttributeTransformation(Schema schema, String attributeName, Collection<String> newValues) {
        this(schema, new Attribute(attributeName, schema, newValues));
    }

    public ReplaceAttributeTransformation(Schema schema, Attribute ... attributes) {
        this(schema, StaticUtils.toList(attributes));
    }

    public ReplaceAttributeTransformation(Schema schema, Collection<Attribute> attributes) {
        Schema s2 = schema;
        if (s2 == null) {
            try {
                s2 = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s2;
        HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>(StaticUtils.computeMapCapacity(10));
        for (Attribute a : attributes) {
            AttributeTypeDefinition at;
            String baseName = StaticUtils.toLowerCase(a.getBaseName());
            attrMap.put(baseName, a);
            if (s2 == null || (at = s2.getAttributeType(baseName)) == null) continue;
            attrMap.put(StaticUtils.toLowerCase(at.getOID()), new Attribute(at.getOID(), s2, a.getValues()));
            for (String name : at.getNames()) {
                String lowerName = StaticUtils.toLowerCase(name);
                if (attrMap.containsKey(lowerName)) continue;
                attrMap.put(lowerName, new Attribute(name, s2, a.getValues()));
            }
        }
        this.attributes = Collections.unmodifiableMap(attrMap);
    }

    @Override
    public Entry transformEntry(Entry e) {
        if (e == null) {
            return null;
        }
        boolean hasAttributeToReplace = false;
        Collection<Attribute> originalAttributes = e.getAttributes();
        for (Attribute a : originalAttributes) {
            if (!this.attributes.containsKey(StaticUtils.toLowerCase(a.getBaseName()))) continue;
            hasAttributeToReplace = true;
            break;
        }
        if (!hasAttributeToReplace) {
            return e;
        }
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(originalAttributes.size());
        for (Attribute a : originalAttributes) {
            Attribute replacement = this.attributes.get(StaticUtils.toLowerCase(a.getBaseName()));
            if (replacement == null) {
                newAttributes.add(a);
                continue;
            }
            if (a.hasOptions()) {
                newAttributes.add(new Attribute(a.getName(), this.schema, replacement.getRawValues()));
                continue;
            }
            newAttributes.add(replacement);
        }
        return new Entry(e.getDN(), this.schema, newAttributes);
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }
}

