/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FlattenSubtreeTransformation
implements EntryTransformation,
Serializable {
    private static final long serialVersionUID = -5500436195237056110L;
    private final boolean addOmittedRDNAttributesToEntry;
    private final boolean addOmittedRDNAttributesToRDN;
    private final DN flattenBaseDN;
    private final Filter excludeFilter;
    private final RDN[] flattenBaseRDNs;
    private final Schema schema;

    public FlattenSubtreeTransformation(Schema schema, DN flattenBaseDN, boolean addOmittedRDNAttributesToEntry, boolean addOmittedRDNAttributesToRDN, Filter excludeFilter) {
        this.flattenBaseDN = flattenBaseDN;
        this.addOmittedRDNAttributesToEntry = addOmittedRDNAttributesToEntry;
        this.addOmittedRDNAttributesToRDN = addOmittedRDNAttributesToRDN;
        this.excludeFilter = excludeFilter;
        this.flattenBaseRDNs = flattenBaseDN.getRDNs();
        Schema s2 = schema;
        if (s2 == null) {
            try {
                s2 = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s2;
    }

    @Override
    public Entry transformEntry(Entry e) {
        LinkedHashSet<ObjectPair<String, String>> omittedRDNValues;
        DN newDN;
        block10: {
            if (e == null) {
                return null;
            }
            newDN = null;
            omittedRDNValues = null;
            try {
                DN dn = e.getParsedDN();
                if (!dn.isDescendantOf(this.flattenBaseDN, false)) break block10;
                try {
                    if (this.excludeFilter != null && this.excludeFilter.matchesEntry(e)) {
                        return null;
                    }
                }
                catch (Exception ex) {
                    Debug.debugException(ex);
                }
                if (this.addOmittedRDNAttributesToEntry || this.addOmittedRDNAttributesToRDN) {
                    omittedRDNValues = new LinkedHashSet<ObjectPair<String, String>>(StaticUtils.computeMapCapacity(5));
                }
                newDN = this.transformDN(dn, omittedRDNValues);
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                return e;
            }
        }
        Collection<Attribute> originalAttributes = e.getAttributes();
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(originalAttributes.size());
        LinkedHashSet<ObjectPair<String, String>> tempOmittedRDNValues = this.addOmittedRDNAttributesToRDN ? new LinkedHashSet<ObjectPair<String, String>>(StaticUtils.computeMapCapacity(5)) : null;
        for (Attribute a : originalAttributes) {
            newAttributes.add(this.transformAttribute(a, tempOmittedRDNValues));
        }
        Entry newEntry = newDN == null ? new Entry(e.getDN(), this.schema, newAttributes) : new Entry(newDN, this.schema, newAttributes);
        if (this.addOmittedRDNAttributesToEntry && omittedRDNValues != null) {
            for (ObjectPair objectPair : omittedRDNValues) {
                newEntry.addAttribute(new Attribute((String)objectPair.getFirst(), this.schema, (String)objectPair.getSecond()));
            }
        }
        return newEntry;
    }

    private DN transformDN(DN dn, Set<ObjectPair<String, String>> omittedRDNValues) {
        RDN[] originalRDNs = dn.getRDNs();
        int numRDNsToOmit = originalRDNs.length - this.flattenBaseRDNs.length - 1;
        if (numRDNsToOmit == 0) {
            return dn;
        }
        RDN[] newRDNs = new RDN[this.flattenBaseRDNs.length + 1];
        System.arraycopy(this.flattenBaseRDNs, 0, newRDNs, 1, this.flattenBaseRDNs.length);
        if (omittedRDNValues == null) {
            newRDNs[0] = originalRDNs[0];
        } else {
            for (int i = 1; i <= numRDNsToOmit; ++i) {
                String[] names = originalRDNs[i].getAttributeNames();
                String[] values = originalRDNs[i].getAttributeValues();
                for (int j = 0; j < names.length; ++j) {
                    omittedRDNValues.add(new ObjectPair<String, String>(names[j], values[j]));
                }
            }
            String[] origNames = originalRDNs[0].getAttributeNames();
            String[] origValues = originalRDNs[0].getAttributeValues();
            for (int i = 0; i < origNames.length; ++i) {
                omittedRDNValues.remove(new ObjectPair<String, String>(origNames[i], origValues[i]));
            }
            if (this.addOmittedRDNAttributesToRDN) {
                String[] originalRDNNames = originalRDNs[0].getAttributeNames();
                String[] originalRDNValues = originalRDNs[0].getAttributeValues();
                String[] newRDNNames = new String[originalRDNNames.length + omittedRDNValues.size()];
                String[] newRDNValues = new String[newRDNNames.length];
                int i = 0;
                for (int j = 0; j < originalRDNNames.length; ++j) {
                    newRDNNames[i] = originalRDNNames[i];
                    newRDNValues[i] = originalRDNValues[i];
                    ++i;
                }
                for (ObjectPair<String, String> p : omittedRDNValues) {
                    newRDNNames[i] = p.getFirst();
                    newRDNValues[i] = p.getSecond();
                    ++i;
                }
                newRDNs[0] = new RDN(newRDNNames, newRDNValues, this.schema);
            } else {
                newRDNs[0] = originalRDNs[0];
            }
        }
        return new DN(newRDNs);
    }

    private Attribute transformAttribute(Attribute a, Set<ObjectPair<String, String>> omittedRDNValues) {
        String[] values;
        boolean hasTransformableDN = false;
        for (String value : values = a.getValues()) {
            try {
                DN dn = new DN(value);
                if (!dn.isDescendantOf(this.flattenBaseDN, false)) continue;
                hasTransformableDN = true;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!hasTransformableDN) {
            return a;
        }
        String[] newValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                DN dn = new DN(values[i]);
                if (dn.isDescendantOf(this.flattenBaseDN, false)) {
                    if (omittedRDNValues != null) {
                        omittedRDNValues.clear();
                    }
                    newValues[i] = this.transformDN(dn, omittedRDNValues).toString();
                    continue;
                }
                newValues[i] = values[i];
                continue;
            }
            catch (Exception e) {
                newValues[i] = values[i];
            }
        }
        return new Attribute(a.getName(), this.schema, newValues);
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }
}

