/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExcludeEntryTransformation
implements EntryTransformation,
Serializable {
    private static final long serialVersionUID = 103514669827637043L;
    private final AtomicLong excludedCount;
    private final boolean allEntriesMatchFilter;
    private final boolean allEntriesAreInScope;
    private final boolean excludeMatching;
    private final DN baseDN;
    private final Filter filter;
    private final Schema schema;
    private final SearchScope scope;

    public ExcludeEntryTransformation(Schema schema, DN baseDN, SearchScope scope, Filter filter, boolean excludeMatching, AtomicLong excludedCount) {
        this.excludeMatching = excludeMatching;
        this.excludedCount = excludedCount;
        Schema s2 = schema;
        if (s2 == null) {
            try {
                s2 = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s2;
        this.baseDN = baseDN == null ? DN.NULL_DN : baseDN;
        this.scope = scope == null ? SearchScope.SUB : scope;
        boolean bl = this.allEntriesAreInScope = this.baseDN.isNullDN() && this.scope == SearchScope.SUB;
        if (filter == null) {
            this.filter = Filter.createANDFilter(new Filter[0]);
            this.allEntriesMatchFilter = true;
        } else {
            this.filter = filter;
            this.allEntriesMatchFilter = filter.getFilterType() == -96 ? filter.getComponents().length == 0 : false;
        }
    }

    @Override
    public Entry transformEntry(Entry e) {
        boolean matchesFilter;
        boolean matchesScope;
        if (e == null) {
            return null;
        }
        try {
            matchesScope = this.allEntriesAreInScope || e.matchesBaseAndScope(this.baseDN, this.scope);
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            matchesScope = false;
        }
        try {
            matchesFilter = this.allEntriesMatchFilter || this.filter.matchesEntry(e, this.schema);
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            matchesFilter = false;
        }
        if (matchesScope && matchesFilter) {
            if (this.excludeMatching) {
                if (this.excludedCount != null) {
                    this.excludedCount.incrementAndGet();
                }
                return null;
            }
            return e;
        }
        if (this.excludeMatching) {
            return e;
        }
        if (this.excludedCount != null) {
            this.excludedCount.incrementAndGet();
        }
        return null;
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }
}

