/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DNEntrySource;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.LDAPPersister;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.persist.PersistedObjects;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.UUID;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PersistUtils {
    private PersistUtils() {
    }

    public static boolean isValidLDAPName(String s2, StringBuilder r) {
        return PersistUtils.isValidLDAPName(s2, false, r);
    }

    public static boolean isValidLDAPName(String s2, boolean o, StringBuilder r) {
        String baseName;
        int length;
        if (s2 == null || (length = s2.length()) == 0) {
            r.append(PersistMessages.ERR_LDAP_NAME_VALIDATOR_EMPTY.get());
            return false;
        }
        int semicolonPos = s2.indexOf(59);
        if (semicolonPos > 0) {
            if (!o) {
                r.append(PersistMessages.ERR_LDAP_NAME_VALIDATOR_INVALID_CHAR.get(s2, Character.valueOf(';'), semicolonPos));
                return false;
            }
            baseName = s2.substring(0, semicolonPos);
            length = baseName.length();
            String optionsStr = s2.substring(semicolonPos + 1);
            if (!PersistUtils.isValidOptionSet(baseName, optionsStr, r)) {
                return false;
            }
        } else {
            baseName = s2;
        }
        if (StaticUtils.isNumericOID(baseName)) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            char c = baseName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            if (c >= '0' && c <= '9' || c == '-') {
                if (i != 0) continue;
                r.append(PersistMessages.ERR_LDAP_NAME_VALIDATOR_INVALID_FIRST_CHAR.get(s2));
                return false;
            }
            r.append(PersistMessages.ERR_LDAP_NAME_VALIDATOR_INVALID_CHAR.get(s2, Character.valueOf(c), i));
            return false;
        }
        return true;
    }

    private static boolean isValidOptionSet(String b, String o, StringBuilder r) {
        boolean lastWasSemicolon = true;
        for (int i = 0; i < o.length(); ++i) {
            char c = o.charAt(i);
            if (c == ';') {
                if (lastWasSemicolon) {
                    r.append(PersistMessages.ERR_LDAP_NAME_VALIDATOR_OPTION_WITH_CONSECUTIVE_SEMICOLONS.get(b + ';' + o));
                    return false;
                }
                lastWasSemicolon = true;
                continue;
            }
            lastWasSemicolon = false;
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') continue;
            r.append(PersistMessages.ERR_LDAP_NAME_VALIDATOR_INVALID_OPTION_CHAR.get(b + ';' + o, Character.valueOf(c), b.length() + 1 + i));
            return false;
        }
        if (lastWasSemicolon) {
            r.append(PersistMessages.ERR_LDAP_NAME_VALIDATOR_ENDS_WITH_SEMICOLON.get(b + ';' + o));
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String s2, StringBuilder r) {
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') continue;
            if (c >= '0' && c <= '9') {
                if (i != 0) continue;
                r.append(PersistMessages.ERR_JAVA_NAME_VALIDATOR_INVALID_FIRST_CHAR_DIGIT.get(s2));
                return false;
            }
            r.append(PersistMessages.ERR_JAVA_NAME_VALIDATOR_INVALID_CHAR.get(s2, Character.valueOf(c), i));
            return false;
        }
        return true;
    }

    public static String toJavaIdentifier(String s2) {
        int length;
        if (s2 == null || (length = s2.length()) == 0) {
            return PersistUtils.toJavaIdentifier(UUID.randomUUID().toString());
        }
        boolean nextUpper = false;
        StringBuilder b = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                if (nextUpper) {
                    b.append(Character.toUpperCase(c));
                } else {
                    b.append(c);
                }
                nextUpper = false;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (i == 0) {
                    b.append('_');
                }
                b.append(c);
                nextUpper = false;
                continue;
            }
            nextUpper = true;
        }
        if (b.length() == 0) {
            return PersistUtils.toJavaIdentifier(UUID.randomUUID().toString());
        }
        return b.toString();
    }

    public static <T> T getEntryAsObject(DN dn, Class<T> type, LDAPInterface conn) throws LDAPException {
        Validator.ensureNotNull(dn, type, conn);
        LDAPPersister<T> p = LDAPPersister.getInstance(type);
        SearchResultEntry e = conn.getEntry(dn.toString(), p.getObjectHandler().getAttributesToRequest());
        if (e == null) {
            return null;
        }
        return p.decode(e);
    }

    public static <T> PersistedObjects<T> getEntriesAsObjects(DN[] dns, Class<T> type, LDAPInterface conn) throws LDAPPersistException {
        Validator.ensureNotNull(dns, type, conn);
        LDAPPersister<T> p = LDAPPersister.getInstance(type);
        DNEntrySource entrySource = new DNEntrySource(conn, dns, p.getObjectHandler().getAttributesToRequest());
        return new PersistedObjects<T>(p, entrySource);
    }
}

