/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.jndi;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.migrate.jndi.JNDIExtendedRequest;
import com.unboundid.ldap.sdk.migrate.jndi.JNDIExtendedResponse;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.ExtendedResponse;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JNDIConverter {
    private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    private static final javax.naming.ldap.Control[] NO_JNDI_CONTROLS = new javax.naming.ldap.Control[0];
    private static final Modification[] NO_MODIFICATIONS = new Modification[0];
    private static final ModificationItem[] NO_MODIFICATION_ITEMS = new ModificationItem[0];
    private static final Control[] NO_SDK_CONTROLS = new Control[0];

    private JNDIConverter() {
    }

    public static Attribute convertAttribute(javax.naming.directory.Attribute a) throws NamingException {
        if (a == null) {
            return null;
        }
        String name = a.getID();
        ASN1OctetString[] values = new ASN1OctetString[a.size()];
        for (int i = 0; i < values.length; ++i) {
            Object value = a.get(i);
            values[i] = value instanceof byte[] ? new ASN1OctetString((byte[])value) : new ASN1OctetString(String.valueOf(value));
        }
        return new Attribute(name, values);
    }

    public static javax.naming.directory.Attribute convertAttribute(Attribute a) {
        if (a == null) {
            return null;
        }
        BasicAttribute attr = new BasicAttribute(a.getName(), true);
        for (String v : a.getValues()) {
            attr.add(v);
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attribute[] convertAttributes(Attributes a) throws NamingException {
        if (a == null) {
            return NO_ATTRIBUTES;
        }
        int i = 0;
        Attribute[] attributes = new Attribute[a.size()];
        try (NamingEnumeration<? extends javax.naming.directory.Attribute> e = a.getAll();){
            while (e.hasMoreElements()) {
                attributes[i++] = JNDIConverter.convertAttribute(e.next());
            }
        }
        return attributes;
    }

    public static Attributes convertAttributes(Attribute ... a) {
        BasicAttributes attrs = new BasicAttributes(true);
        if (a == null) {
            return attrs;
        }
        for (Attribute attr : a) {
            attrs.put(JNDIConverter.convertAttribute(attr));
        }
        return attrs;
    }

    public static Attributes convertAttributes(Collection<Attribute> a) {
        BasicAttributes attrs = new BasicAttributes(true);
        if (a == null) {
            return attrs;
        }
        for (Attribute attr : a) {
            attrs.put(JNDIConverter.convertAttribute(attr));
        }
        return attrs;
    }

    public static Control convertControl(javax.naming.ldap.Control c) throws NamingException {
        ASN1OctetString value;
        if (c == null) {
            return null;
        }
        byte[] valueBytes = c.getEncodedValue();
        if (valueBytes == null || valueBytes.length == 0) {
            value = null;
        } else {
            try {
                value = ASN1OctetString.decodeAsOctetString(valueBytes);
            }
            catch (ASN1Exception ae) {
                throw new NamingException(StaticUtils.getExceptionMessage(ae));
            }
        }
        return new Control(c.getID(), c.isCritical(), value);
    }

    public static javax.naming.ldap.Control convertControl(Control c) {
        if (c == null) {
            return null;
        }
        ASN1OctetString value = c.getValue();
        if (value == null) {
            return new BasicControl(c.getOID(), c.isCritical(), null);
        }
        return new BasicControl(c.getOID(), c.isCritical(), value.encode());
    }

    public static Control[] convertControls(javax.naming.ldap.Control ... c) throws NamingException {
        if (c == null) {
            return NO_SDK_CONTROLS;
        }
        Control[] controls = new Control[c.length];
        for (int i = 0; i < controls.length; ++i) {
            controls[i] = JNDIConverter.convertControl(c[i]);
        }
        return controls;
    }

    public static javax.naming.ldap.Control[] convertControls(Control ... c) {
        if (c == null) {
            return NO_JNDI_CONTROLS;
        }
        javax.naming.ldap.Control[] controls = new javax.naming.ldap.Control[c.length];
        for (int i = 0; i < controls.length; ++i) {
            controls[i] = JNDIConverter.convertControl(c[i]);
        }
        return controls;
    }

    public static ExtendedRequest convertExtendedRequest(javax.naming.ldap.ExtendedRequest r) throws NamingException {
        if (r == null) {
            return null;
        }
        return JNDIExtendedRequest.toSDKExtendedRequest(r);
    }

    public static javax.naming.ldap.ExtendedRequest convertExtendedRequest(ExtendedRequest r) {
        if (r == null) {
            return null;
        }
        return new JNDIExtendedRequest(r);
    }

    public static ExtendedResult convertExtendedResponse(ExtendedResponse r) throws NamingException {
        if (r == null) {
            return null;
        }
        return JNDIExtendedResponse.toSDKExtendedResult(r);
    }

    public static ExtendedResponse convertExtendedResult(ExtendedResult r) {
        if (r == null) {
            return null;
        }
        return new JNDIExtendedResponse(r);
    }

    public static Modification convertModification(ModificationItem m3) throws NamingException {
        ModificationType modType;
        if (m3 == null) {
            return null;
        }
        switch (m3.getModificationOp()) {
            case 1: {
                modType = ModificationType.ADD;
                break;
            }
            case 3: {
                modType = ModificationType.DELETE;
                break;
            }
            case 2: {
                modType = ModificationType.REPLACE;
                break;
            }
            default: {
                throw new NamingException("Unsupported modification type " + m3);
            }
        }
        Attribute a = JNDIConverter.convertAttribute(m3.getAttribute());
        return new Modification(modType, a.getName(), a.getRawValues());
    }

    public static ModificationItem convertModification(Modification m3) throws NamingException {
        int modType;
        if (m3 == null) {
            return null;
        }
        switch (m3.getModificationType().intValue()) {
            case 0: {
                modType = 1;
                break;
            }
            case 1: {
                modType = 3;
                break;
            }
            case 2: {
                modType = 2;
                break;
            }
            default: {
                throw new NamingException("Unsupported modification type " + m3);
            }
        }
        return new ModificationItem(modType, JNDIConverter.convertAttribute(m3.getAttribute()));
    }

    public static Modification[] convertModifications(ModificationItem ... m3) throws NamingException {
        if (m3 == null) {
            return NO_MODIFICATIONS;
        }
        Modification[] mods = new Modification[m3.length];
        for (int i = 0; i < m3.length; ++i) {
            mods[i] = JNDIConverter.convertModification(m3[i]);
        }
        return mods;
    }

    public static ModificationItem[] convertModifications(Modification ... m3) throws NamingException {
        if (m3 == null) {
            return NO_MODIFICATION_ITEMS;
        }
        ModificationItem[] mods = new ModificationItem[m3.length];
        for (int i = 0; i < m3.length; ++i) {
            mods[i] = JNDIConverter.convertModification(m3[i]);
        }
        return mods;
    }

    public static Entry convertSearchEntry(SearchResult r) throws NamingException {
        return JNDIConverter.convertSearchEntry(r, null);
    }

    public static Entry convertSearchEntry(SearchResult r, String contextBaseDN) throws NamingException {
        String name;
        if (r == null) {
            return null;
        }
        String dn = contextBaseDN == null || contextBaseDN.isEmpty() ? r.getName() : ((name = r.getName()) == null || name.isEmpty() ? contextBaseDN : r.getName() + ',' + contextBaseDN);
        return new Entry(dn, JNDIConverter.convertAttributes(r.getAttributes()));
    }

    public static SearchResult convertSearchEntry(Entry e) {
        return JNDIConverter.convertSearchEntry(e, null);
    }

    public static SearchResult convertSearchEntry(Entry e, String contextBaseDN) {
        if (e == null) {
            return null;
        }
        String name = e.getDN();
        if (contextBaseDN != null && !contextBaseDN.isEmpty()) {
            try {
                DN parsedEntryDN = e.getParsedDN();
                DN parsedBaseDN = new DN(contextBaseDN);
                if (parsedEntryDN.equals(parsedBaseDN)) {
                    name = "";
                } else if (parsedEntryDN.isDescendantOf(parsedBaseDN, false)) {
                    RDN[] entryRDNs = parsedEntryDN.getRDNs();
                    RDN[] baseRDNs = parsedBaseDN.getRDNs();
                    RDN[] remainingRDNs = new RDN[entryRDNs.length - baseRDNs.length];
                    System.arraycopy(entryRDNs, 0, remainingRDNs, 0, remainingRDNs.length);
                    name = new DN(remainingRDNs).toString();
                }
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        Collection<Attribute> attrs = e.getAttributes();
        Attribute[] attributes = new Attribute[attrs.size()];
        attrs.toArray(attributes);
        return new SearchResult(name, (Object)null, JNDIConverter.convertAttributes(attributes));
    }
}

