/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPURL
implements Serializable {
    private static final Filter DEFAULT_FILTER = Filter.createPresenceFilter("objectClass");
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final int DEFAULT_LDAPS_PORT = 636;
    public static final int DEFAULT_LDAPI_PORT = 0;
    private static final SearchScope DEFAULT_SCOPE = SearchScope.BASE;
    private static final DN DEFAULT_BASE_DN = DN.NULL_DN;
    private static final String[] DEFAULT_ATTRIBUTES = StaticUtils.NO_STRINGS;
    private static final long serialVersionUID = 3420786933570240493L;
    private final boolean attributesProvided;
    private final boolean baseDNProvided;
    private final boolean filterProvided;
    private final boolean portProvided;
    private final boolean scopeProvided;
    private final DN baseDN;
    private final Filter filter;
    private final int port;
    private final SearchScope scope;
    private final String host;
    private volatile String normalizedURLString;
    private final String scheme;
    private final String urlString;
    private final String[] attributes;

    public LDAPURL(String urlString) throws LDAPException {
        StringBuilder hostBuffer;
        int defaultPort;
        Validator.ensureNotNull(urlString);
        this.urlString = urlString;
        int colonPos = urlString.indexOf("://");
        if (colonPos < 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_NO_COLON_SLASHES.get());
        }
        this.scheme = StaticUtils.toLowerCase(urlString.substring(0, colonPos));
        if (this.scheme.equals("ldap")) {
            defaultPort = 389;
        } else if (this.scheme.equals("ldaps")) {
            defaultPort = 636;
        } else if (this.scheme.equals("ldapi")) {
            defaultPort = 0;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCHEME.get(this.scheme));
        }
        int slashPos = urlString.indexOf(47, colonPos + 3);
        if (slashPos < 0) {
            StringBuilder hostBuffer2;
            this.baseDN = DEFAULT_BASE_DN;
            this.baseDNProvided = false;
            this.attributes = DEFAULT_ATTRIBUTES;
            this.attributesProvided = false;
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            String hostPort = urlString.substring(colonPos + 3);
            int portValue = LDAPURL.decodeHostPort(hostPort, hostBuffer2 = new StringBuilder(hostPort.length()));
            if (portValue < 0) {
                this.port = defaultPort;
                this.portProvided = false;
            } else {
                this.port = portValue;
                this.portProvided = true;
            }
            this.host = hostBuffer2.length() == 0 ? null : hostBuffer2.toString();
            return;
        }
        String hostPort = urlString.substring(colonPos + 3, slashPos);
        int portValue = LDAPURL.decodeHostPort(hostPort, hostBuffer = new StringBuilder(hostPort.length()));
        if (portValue < 0) {
            this.port = defaultPort;
            this.portProvided = false;
        } else {
            this.port = portValue;
            this.portProvided = true;
        }
        this.host = hostBuffer.length() == 0 ? null : hostBuffer.toString();
        int questionMarkPos = urlString.indexOf(63, slashPos + 1);
        if (questionMarkPos < 0) {
            this.attributes = DEFAULT_ATTRIBUTES;
            this.attributesProvided = false;
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            this.baseDN = new DN(LDAPURL.percentDecode(urlString.substring(slashPos + 1)));
            this.baseDNProvided = !this.baseDN.isNullDN();
            return;
        }
        this.baseDN = new DN(LDAPURL.percentDecode(urlString.substring(slashPos + 1, questionMarkPos)));
        this.baseDNProvided = !this.baseDN.isNullDN();
        int questionMark2Pos = urlString.indexOf(63, questionMarkPos + 1);
        if (questionMark2Pos < 0) {
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            this.attributes = LDAPURL.decodeAttributes(urlString.substring(questionMarkPos + 1));
            this.attributesProvided = this.attributes.length > 0;
            return;
        }
        this.attributes = LDAPURL.decodeAttributes(urlString.substring(questionMarkPos + 1, questionMark2Pos));
        this.attributesProvided = this.attributes.length > 0;
        int questionMark3Pos = urlString.indexOf(63, questionMark2Pos + 1);
        if (questionMark3Pos < 0) {
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            String scopeStr = StaticUtils.toLowerCase(urlString.substring(questionMark2Pos + 1));
            if (scopeStr.isEmpty()) {
                this.scope = SearchScope.BASE;
                this.scopeProvided = false;
            } else if (scopeStr.equals("base")) {
                this.scope = SearchScope.BASE;
                this.scopeProvided = true;
            } else if (scopeStr.equals("one")) {
                this.scope = SearchScope.ONE;
                this.scopeProvided = true;
            } else if (scopeStr.equals("sub")) {
                this.scope = SearchScope.SUB;
                this.scopeProvided = true;
            } else if (scopeStr.equals("subord") || scopeStr.equals("subordinates")) {
                this.scope = SearchScope.SUBORDINATE_SUBTREE;
                this.scopeProvided = true;
            } else {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCOPE.get(scopeStr));
            }
            return;
        }
        String scopeStr = StaticUtils.toLowerCase(urlString.substring(questionMark2Pos + 1, questionMark3Pos));
        if (scopeStr.isEmpty()) {
            this.scope = SearchScope.BASE;
            this.scopeProvided = false;
        } else if (scopeStr.equals("base")) {
            this.scope = SearchScope.BASE;
            this.scopeProvided = true;
        } else if (scopeStr.equals("one")) {
            this.scope = SearchScope.ONE;
            this.scopeProvided = true;
        } else if (scopeStr.equals("sub")) {
            this.scope = SearchScope.SUB;
            this.scopeProvided = true;
        } else if (scopeStr.equals("subord") || scopeStr.equals("subordinates")) {
            this.scope = SearchScope.SUBORDINATE_SUBTREE;
            this.scopeProvided = true;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCOPE.get(scopeStr));
        }
        String filterStr = LDAPURL.percentDecode(urlString.substring(questionMark3Pos + 1));
        if (filterStr.isEmpty()) {
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
        } else {
            this.filter = Filter.create(filterStr);
            this.filterProvided = true;
        }
    }

    public LDAPURL(String scheme, String host, Integer port, DN baseDN, String[] attributes, SearchScope scope, Filter filter) throws LDAPException {
        int defaultPort;
        Validator.ensureNotNull(scheme);
        StringBuilder buffer = new StringBuilder();
        this.scheme = StaticUtils.toLowerCase(scheme);
        if (scheme.equals("ldap")) {
            defaultPort = 389;
        } else if (scheme.equals("ldaps")) {
            defaultPort = 636;
        } else if (scheme.equals("ldapi")) {
            defaultPort = 0;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCHEME.get(scheme));
        }
        buffer.append(scheme);
        buffer.append("://");
        if (host == null || host.isEmpty()) {
            this.host = null;
        } else {
            this.host = host;
            buffer.append(host);
        }
        if (port == null) {
            this.port = defaultPort;
            this.portProvided = false;
        } else {
            this.port = port;
            this.portProvided = true;
            buffer.append(':');
            buffer.append(port);
            if (port < 1 || port > 65535) {
                throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_PORT.get(port));
            }
        }
        buffer.append('/');
        if (baseDN == null) {
            this.baseDN = DEFAULT_BASE_DN;
            this.baseDNProvided = false;
        } else {
            this.baseDN = baseDN;
            this.baseDNProvided = true;
            LDAPURL.percentEncode(baseDN.toString(), buffer);
        }
        boolean continueAppending = attributes != null && attributes.length != 0 || scope != null || filter != null;
        if (continueAppending) {
            buffer.append('?');
        }
        if (attributes == null || attributes.length == 0) {
            this.attributes = DEFAULT_ATTRIBUTES;
            this.attributesProvided = false;
        } else {
            this.attributes = attributes;
            this.attributesProvided = true;
            for (int i = 0; i < attributes.length; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(attributes[i]);
            }
        }
        if (continueAppending) {
            buffer.append('?');
        }
        if (scope == null) {
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
        } else {
            switch (scope.intValue()) {
                case 0: {
                    this.scope = scope;
                    this.scopeProvided = true;
                    buffer.append("base");
                    break;
                }
                case 1: {
                    this.scope = scope;
                    this.scopeProvided = true;
                    buffer.append("one");
                    break;
                }
                case 2: {
                    this.scope = scope;
                    this.scopeProvided = true;
                    buffer.append("sub");
                    break;
                }
                case 3: {
                    this.scope = scope;
                    this.scopeProvided = true;
                    buffer.append("subordinates");
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCOPE_VALUE.get(scope));
                }
            }
        }
        if (continueAppending) {
            buffer.append('?');
        }
        if (filter == null) {
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
        } else {
            this.filter = filter;
            this.filterProvided = true;
            LDAPURL.percentEncode(filter.toString(), buffer);
        }
        this.urlString = buffer.toString();
    }

    private static int decodeHostPort(String hostPort, StringBuilder hostBuffer) throws LDAPException {
        int length = hostPort.length();
        if (length == 0) {
            return -1;
        }
        if (hostPort.charAt(0) == '[') {
            int closingBracketPos = hostPort.indexOf(93);
            if (closingBracketPos < 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_IPV6_HOST_MISSING_BRACKET.get());
            }
            hostBuffer.append(hostPort.substring(1, closingBracketPos).trim());
            if (hostBuffer.length() == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_IPV6_HOST_EMPTY.get());
            }
            if (closingBracketPos == length - 1) {
                return -1;
            }
            if (hostPort.charAt(closingBracketPos + 1) != ':') {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_IPV6_HOST_UNEXPECTED_CHAR.get(Character.valueOf(hostPort.charAt(closingBracketPos + 1))));
            }
            try {
                int decodedPort = Integer.parseInt(hostPort.substring(closingBracketPos + 2));
                if (decodedPort >= 1 && decodedPort <= 65535) {
                    return decodedPort;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_PORT.get(decodedPort));
            }
            catch (NumberFormatException nfe) {
                Debug.debugException(nfe);
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_PORT_NOT_INT.get(hostPort), nfe);
            }
        }
        int colonPos = hostPort.indexOf(58);
        if (colonPos < 0) {
            hostBuffer.append(hostPort);
            return -1;
        }
        try {
            int decodedPort = Integer.parseInt(hostPort.substring(colonPos + 1));
            if (decodedPort >= 1 && decodedPort <= 65535) {
                hostBuffer.append(hostPort.substring(0, colonPos));
                return decodedPort;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_PORT.get(decodedPort));
        }
        catch (NumberFormatException nfe) {
            Debug.debugException(nfe);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_PORT_NOT_INT.get(hostPort), nfe);
        }
    }

    private static String[] decodeAttributes(String s2) throws LDAPException {
        int length = s2.length();
        if (length == 0) {
            return DEFAULT_ATTRIBUTES;
        }
        ArrayList<String> attrList = new ArrayList<String>(10);
        int startPos = 0;
        while (startPos < length) {
            String attrName;
            int commaPos = s2.indexOf(44, startPos);
            if (commaPos < 0) {
                attrName = s2.substring(startPos).trim();
                if (attrName.isEmpty()) {
                    if (attrList.isEmpty()) {
                        return DEFAULT_ATTRIBUTES;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_ATTRLIST_ENDS_WITH_COMMA.get());
                }
                attrList.add(attrName);
                break;
            }
            attrName = s2.substring(startPos, commaPos).trim();
            if (attrName.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_ATTRLIST_EMPTY_ATTRIBUTE.get());
            }
            attrList.add(attrName);
            startPos = commaPos + 1;
            if (startPos < length) continue;
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_ATTRLIST_ENDS_WITH_COMMA.get());
        }
        String[] attributes = new String[attrList.size()];
        attrList.toArray(attributes);
        return attributes;
    }

    public static String percentDecode(String s2) throws LDAPException {
        int firstPercentPos = -1;
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            if (s2.charAt(i) != '%') continue;
            firstPercentPos = i;
            break;
        }
        if (firstPercentPos < 0) {
            return s2;
        }
        int pos = firstPercentPos;
        ByteStringBuffer buffer = new ByteStringBuffer(2 * length);
        buffer.append(s2.substring(0, firstPercentPos));
        while (pos < length) {
            char c;
            if ((c = s2.charAt(pos++)) == '%') {
                byte b;
                if (pos >= length) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_HEX_STRING_TOO_SHORT.get(s2));
                }
                switch (s2.charAt(pos++)) {
                    case '0': {
                        b = 0;
                        break;
                    }
                    case '1': {
                        b = 16;
                        break;
                    }
                    case '2': {
                        b = 32;
                        break;
                    }
                    case '3': {
                        b = 48;
                        break;
                    }
                    case '4': {
                        b = 64;
                        break;
                    }
                    case '5': {
                        b = 80;
                        break;
                    }
                    case '6': {
                        b = 96;
                        break;
                    }
                    case '7': {
                        b = 112;
                        break;
                    }
                    case '8': {
                        b = -128;
                        break;
                    }
                    case '9': {
                        b = -112;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        b = -96;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        b = -80;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        b = -64;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        b = -48;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        b = -32;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        b = -16;
                        break;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_HEX_CHAR.get(Character.valueOf(s2.charAt(pos - 1))));
                    }
                }
                if (pos >= length) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_HEX_STRING_TOO_SHORT.get(s2));
                }
                switch (s2.charAt(pos++)) {
                    case '0': {
                        buffer.append(b);
                        break;
                    }
                    case '1': {
                        buffer.append((byte)(b | 1));
                        break;
                    }
                    case '2': {
                        buffer.append((byte)(b | 2));
                        break;
                    }
                    case '3': {
                        buffer.append((byte)(b | 3));
                        break;
                    }
                    case '4': {
                        buffer.append((byte)(b | 4));
                        break;
                    }
                    case '5': {
                        buffer.append((byte)(b | 5));
                        break;
                    }
                    case '6': {
                        buffer.append((byte)(b | 6));
                        break;
                    }
                    case '7': {
                        buffer.append((byte)(b | 7));
                        break;
                    }
                    case '8': {
                        buffer.append((byte)(b | 8));
                        break;
                    }
                    case '9': {
                        buffer.append((byte)(b | 9));
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        buffer.append((byte)(b | 0xA));
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        buffer.append((byte)(b | 0xB));
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        buffer.append((byte)(b | 0xC));
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        buffer.append((byte)(b | 0xD));
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        buffer.append((byte)(b | 0xE));
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        buffer.append((byte)(b | 0xF));
                        break;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_HEX_CHAR.get(Character.valueOf(s2.charAt(pos - 1))));
                    }
                }
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static void percentEncode(String s2, StringBuilder buffer) {
        int length = s2.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ';': 
                case '=': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '~': {
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    byte[] charBytes;
                    for (byte b : charBytes = StaticUtils.getBytes(new String(new char[]{c}))) {
                        buffer.append('%');
                        StaticUtils.toHex(b, buffer);
                    }
                }
            }
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public boolean hostProvided() {
        return this.host != null;
    }

    public int getPort() {
        return this.port;
    }

    public boolean portProvided() {
        return this.portProvided;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public boolean baseDNProvided() {
        return this.baseDNProvided;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public boolean attributesProvided() {
        return this.attributesProvided;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public boolean scopeProvided() {
        return this.scopeProvided;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean filterProvided() {
        return this.filterProvided;
    }

    public SearchRequest toSearchRequest() {
        return new SearchRequest(this.baseDN.toString(), this.scope, this.filter, this.attributes);
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LDAPURL)) {
            return false;
        }
        LDAPURL url = (LDAPURL)o;
        return this.toNormalizedString().equals(url.toNormalizedString());
    }

    public String toString() {
        return this.urlString;
    }

    public String toNormalizedString() {
        if (this.normalizedURLString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedURLString = buffer.toString();
        }
        return this.normalizedURLString;
    }

    public void toNormalizedString(StringBuilder buffer) {
        buffer.append(this.scheme);
        buffer.append("://");
        if (this.host != null) {
            if (this.host.indexOf(58) >= 0) {
                buffer.append('[');
                buffer.append(StaticUtils.toLowerCase(this.host));
                buffer.append(']');
            } else {
                buffer.append(StaticUtils.toLowerCase(this.host));
            }
        }
        if (!this.scheme.equals("ldapi")) {
            buffer.append(':');
            buffer.append(this.port);
        }
        buffer.append('/');
        LDAPURL.percentEncode(this.baseDN.toNormalizedString(), buffer);
        buffer.append('?');
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(StaticUtils.toLowerCase(this.attributes[i]));
        }
        buffer.append('?');
        switch (this.scope.intValue()) {
            case 0: {
                buffer.append("base");
                break;
            }
            case 1: {
                buffer.append("one");
                break;
            }
            case 2: {
                buffer.append("sub");
                break;
            }
            case 3: {
                buffer.append("subordinates");
            }
        }
        buffer.append('?');
        LDAPURL.percentEncode(this.filter.toNormalizedString(), buffer);
    }
}

