/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

final class ConnectThread
extends Thread {
    private final AtomicBoolean connected;
    private final AtomicReference<Socket> socket;
    private final AtomicReference<Thread> thread;
    private final AtomicReference<Throwable> exception;
    private final CountDownLatch startLatch;
    private final int connectTimeoutMillis;
    private final int port;
    private final SocketFactory socketFactory;
    private final InetAddress address;

    ConnectThread(SocketFactory socketFactory, InetAddress address, int port, int connectTimeoutMillis) {
        super("Background connect thread for " + address + ':' + port);
        this.setDaemon(true);
        this.socketFactory = socketFactory;
        this.address = address;
        this.port = port;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.connected = new AtomicBoolean(false);
        this.socket = new AtomicReference();
        this.thread = new AtomicReference();
        this.exception = new AtomicReference();
        this.startLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            this.thread.set(Thread.currentThread());
            this.startLatch.countDown();
            try {
                boolean connectNeeded;
                Socket s2;
                try {
                    s2 = this.socketFactory.createSocket();
                    connectNeeded = true;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    s2 = this.socketFactory.createSocket(this.address, this.port);
                    connectNeeded = false;
                }
                this.socket.set(s2);
                if (connectNeeded) {
                    s2.connect(new InetSocketAddress(this.address, this.port), this.connectTimeoutMillis);
                }
                this.connected.set(true);
                if (!(s2 instanceof SSLSocket)) break block10;
                try {
                    ((SSLSocket)s2).startHandshake();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    s2.close();
                    throw e;
                }
            }
            catch (Throwable t) {
                Debug.debugException(t);
                this.socket.set(null);
                this.connected.set(false);
                this.exception.set(t);
            }
            finally {
                this.thread.set(null);
            }
        }
    }

    Socket getConnectedSocket() throws LDAPException {
        Thread t;
        if (this.startLatch.getCount() > 0L) {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNECT_THREAD_INTERRUPTED.get(this.address.getHostAddress(), this.port, StaticUtils.getExceptionMessage(ie)), ie);
            }
        }
        if ((t = this.thread.get()) != null) {
            try {
                t.join(this.connectTimeoutMillis);
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNECT_THREAD_INTERRUPTED.get(this.address.getHostAddress(), this.port, StaticUtils.getExceptionMessage(ie)), ie);
            }
        }
        if (this.connected.get()) {
            return this.socket.get();
        }
        try {
            if (t != null) {
                t.interrupt();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            Socket s2 = this.socket.get();
            if (s2 != null) {
                s2.close();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        Throwable cause = this.exception.get();
        if (cause == null) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_TIMEOUT.get(this.address, this.port, this.connectTimeoutMillis));
        }
        StaticUtils.rethrowIfError(cause);
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_EXCEPTION.get(this.address, this.port, StaticUtils.getExceptionMessage(cause)), cause);
    }
}

