/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class CompactAttribute
implements Serializable {
    private static final int MAX_CACHED_NAMES = 1000;
    private static final ConcurrentHashMap<String, String> cachedNames = new ConcurrentHashMap(StaticUtils.computeMapCapacity(1000));
    private static final long serialVersionUID = 9056952830029621727L;
    private final byte[][] values;
    private final String name;

    CompactAttribute(Attribute attribute) {
        this.name = CompactAttribute.internName(attribute.getName());
        this.values = attribute.getValueByteArrays();
    }

    private static String internName(String name) {
        String s2 = cachedNames.get(name);
        if (s2 == null) {
            if (cachedNames.size() >= 1000) {
                cachedNames.clear();
            }
            cachedNames.put(name, name);
            s2 = name;
        }
        return s2;
    }

    String getName() {
        return this.name;
    }

    byte[][] getByteValues() {
        return this.values;
    }

    String[] getStringValues() {
        String[] stringValues = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringValues[i] = StaticUtils.toUTF8String(this.values[i]);
        }
        return stringValues;
    }

    Attribute toAttribute() {
        return new Attribute(this.name, this.values);
    }
}

