/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BindResponseProtocolOp
implements ProtocolOp {
    public static final byte TYPE_SERVER_SASL_CREDENTIALS = -121;
    private static final long serialVersionUID = -7757619031268544913L;
    private final ASN1OctetString serverSASLCredentials;
    private final int resultCode;
    private final List<String> referralURLs;
    private final String diagnosticMessage;
    private final String matchedDN;

    public BindResponseProtocolOp(int resultCode, String matchedDN, String diagnosticMessage, List<String> referralURLs, ASN1OctetString serverSASLCredentials) {
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.diagnosticMessage = diagnosticMessage;
        this.referralURLs = referralURLs == null ? Collections.emptyList() : Collections.unmodifiableList(referralURLs);
        this.serverSASLCredentials = serverSASLCredentials == null ? null : new ASN1OctetString(-121, serverSASLCredentials.getValue());
    }

    public BindResponseProtocolOp(LDAPResult result) {
        this.resultCode = result.getResultCode().intValue();
        this.matchedDN = result.getMatchedDN();
        this.diagnosticMessage = result.getDiagnosticMessage();
        this.referralURLs = StaticUtils.toList(result.getReferralURLs());
        if (result instanceof BindResult) {
            BindResult br = (BindResult)result;
            this.serverSASLCredentials = br.getServerSASLCredentials();
        } else {
            this.serverSASLCredentials = null;
        }
    }

    BindResponseProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            ASN1StreamReaderSequence opSequence = reader.beginSequence();
            this.resultCode = reader.readEnumerated();
            String s2 = reader.readString();
            Validator.ensureNotNull(s2);
            this.matchedDN = s2.isEmpty() ? null : s2;
            s2 = reader.readString();
            Validator.ensureNotNull(s2);
            this.diagnosticMessage = s2.isEmpty() ? null : s2;
            ASN1OctetString creds = null;
            ArrayList<String> refs = new ArrayList<String>(1);
            while (opSequence.hasMoreElements()) {
                byte type = (byte)reader.peek();
                if (type == -93) {
                    ASN1StreamReaderSequence refSequence = reader.beginSequence();
                    while (refSequence.hasMoreElements()) {
                        refs.add(reader.readString());
                    }
                    continue;
                }
                if (type == -121) {
                    creds = new ASN1OctetString(type, reader.readBytes());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(type)));
            }
            this.referralURLs = Collections.unmodifiableList(refs);
            this.serverSASLCredentials = creds;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getMatchedDN() {
        return this.matchedDN;
    }

    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    public ASN1OctetString getServerSASLCredentials() {
        return this.serverSASLCredentials;
    }

    @Override
    public byte getProtocolOpType() {
        return 97;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
        elements.add(new ASN1Enumerated(this.getResultCode()));
        String mDN = this.getMatchedDN();
        if (mDN == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(mDN));
        }
        String dm = this.getDiagnosticMessage();
        if (dm == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(dm));
        }
        List<String> refs = this.getReferralURLs();
        if (!refs.isEmpty()) {
            ArrayList<ASN1OctetString> refElements = new ArrayList<ASN1OctetString>(refs.size());
            for (String r : refs) {
                refElements.add(new ASN1OctetString(r));
            }
            elements.add(new ASN1Sequence(-93, refElements));
        }
        if (this.serverSASLCredentials != null) {
            elements.add(this.serverSASLCredentials);
        }
        return new ASN1Sequence(97, elements);
    }

    public static BindResponseProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            int resultCode = ASN1Enumerated.decodeAsEnumerated(elements[0]).intValue();
            String md = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            String matchedDN = !md.isEmpty() ? md : null;
            String dm = ASN1OctetString.decodeAsOctetString(elements[2]).stringValue();
            String diagnosticMessage = !dm.isEmpty() ? dm : null;
            ASN1OctetString serverSASLCredentials = null;
            ArrayList<String> referralURLs = null;
            if (elements.length > 3) {
                block7: for (int i = 3; i < elements.length; ++i) {
                    switch (elements[i].getType()) {
                        case -93: {
                            ASN1Element[] refElements = ASN1Sequence.decodeAsSequence(elements[3]).elements();
                            referralURLs = new ArrayList<String>(refElements.length);
                            for (ASN1Element e : refElements) {
                                referralURLs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                            }
                            continue block7;
                        }
                        case -121: {
                            serverSASLCredentials = ASN1OctetString.decodeAsOctetString(elements[i]);
                            continue block7;
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(elements[i].getType())));
                        }
                    }
                }
            }
            return new BindResponseProtocolOp(resultCode, matchedDN, diagnosticMessage, referralURLs, serverSASLCredentials);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)97);
        buffer.addEnumerated(this.resultCode);
        buffer.addOctetString(this.matchedDN);
        buffer.addOctetString(this.diagnosticMessage);
        if (!this.referralURLs.isEmpty()) {
            ASN1BufferSequence refSequence = buffer.beginSequence((byte)-93);
            for (String s2 : this.referralURLs) {
                buffer.addOctetString(s2);
            }
            refSequence.end();
        }
        if (this.serverSASLCredentials != null) {
            buffer.addElement(this.serverSASLCredentials);
        }
        opSequence.end();
    }

    public BindResult toBindResult(Control ... controls) {
        String[] refs;
        if (this.referralURLs.isEmpty()) {
            refs = StaticUtils.NO_STRINGS;
        } else {
            refs = new String[this.referralURLs.size()];
            this.referralURLs.toArray(refs);
        }
        return new BindResult(-1, ResultCode.valueOf(this.resultCode), this.diagnosticMessage, this.matchedDN, refs, controls, this.serverSASLCredentials);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("BindResponseProtocolOp(resultCode=");
        buffer.append(this.resultCode);
        if (this.matchedDN != null) {
            buffer.append(", matchedDN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (!this.referralURLs.isEmpty()) {
            buffer.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

