/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

enum InterceptorMessages {
    ERR_DS_INTERCEPTOR_REQUEST_ERROR("An unexpected error was encountered during request processing for operation {0} in an in-memory operation interceptor of type {1}:  {2}"),
    ERR_DS_INTERCEPTOR_RESULT_ERROR("An unexpected error was encountered during result processing for operation {0} in an in-memory operation interceptor of type {1}:  {2}");

    private static final boolean IS_WITHIN_UNIT_TESTS;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<InterceptorMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<InterceptorMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private InterceptorMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    public String get() {
        String s2 = MESSAGE_STRINGS.get((Object)this);
        if (s2 == null) {
            if (RESOURCE_BUNDLE == null) {
                s2 = this.defaultText;
            } else {
                try {
                    s2 = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s2 = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s2);
            }
        }
        if (IS_WITHIN_UNIT_TESTS && (s2.contains("{0}") || s2.contains("{0,number,0}") || s2.contains("{1}") || s2.contains("{1,number,0}") || s2.contains("{2}") || s2.contains("{2,number,0}") || s2.contains("{3}") || s2.contains("{3,number,0}") || s2.contains("{4}") || s2.contains("{4,number,0}") || s2.contains("{5}") || s2.contains("{5,number,0}") || s2.contains("{6}") || s2.contains("{6,number,0}") || s2.contains("{7}") || s2.contains("{7,number,0}") || s2.contains("{8}") || s2.contains("{8,number,0}") || s2.contains("{9}") || s2.contains("{9,number,0}") || s2.contains("{10}") || s2.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + s2);
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(args);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return f.format(args);
    }

    public String toString() {
        String s2 = MESSAGE_STRINGS.get((Object)this);
        if (s2 == null) {
            if (RESOURCE_BUNDLE == null) {
                s2 = this.defaultText;
            } else {
                try {
                    s2 = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s2 = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s2);
            }
        }
        return s2;
    }

    static {
        IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-interceptor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap(100);
        MESSAGES = new ConcurrentHashMap(100);
    }
}

