/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.SearchEntryTransformer;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBuffer;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONAccessLogRequestHandler
extends LDAPListenerRequestHandler
implements SearchEntryTransformer {
    private final AtomicLong nextOperationID;
    private final ConcurrentHashMap<Integer, AtomicLong> entryCounts;
    private final Handler logHandler;
    private final LDAPListenerClientConnection clientConnection;
    private final LDAPListenerRequestHandler requestHandler;
    private final ThreadLocal<DecimalFormat> decimalFormatters;
    private final ThreadLocal<JSONBuffer> jsonBuffers;
    private final ThreadLocal<SimpleDateFormat> timestampFormatters;

    public JSONAccessLogRequestHandler(Handler logHandler, LDAPListenerRequestHandler requestHandler) {
        Validator.ensureNotNull(logHandler, requestHandler);
        this.logHandler = logHandler;
        this.requestHandler = requestHandler;
        this.nextOperationID = null;
        this.clientConnection = null;
        this.entryCounts = new ConcurrentHashMap(StaticUtils.computeMapCapacity(50));
        this.jsonBuffers = new ThreadLocal();
        this.timestampFormatters = new ThreadLocal();
        this.decimalFormatters = new ThreadLocal();
    }

    private JSONAccessLogRequestHandler(Handler logHandler, LDAPListenerRequestHandler requestHandler, LDAPListenerClientConnection clientConnection, ThreadLocal<JSONBuffer> jsonBuffers, ThreadLocal<SimpleDateFormat> timestampFormatters, ThreadLocal<DecimalFormat> decimalFormatters) {
        this.logHandler = logHandler;
        this.requestHandler = requestHandler;
        this.clientConnection = clientConnection;
        this.jsonBuffers = jsonBuffers;
        this.timestampFormatters = timestampFormatters;
        this.decimalFormatters = decimalFormatters;
        this.nextOperationID = new AtomicLong(0L);
        this.entryCounts = new ConcurrentHashMap(StaticUtils.computeMapCapacity(50));
    }

    @Override
    public JSONAccessLogRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        JSONAccessLogRequestHandler h2 = new JSONAccessLogRequestHandler(this.logHandler, this.requestHandler.newInstance(connection), connection, this.jsonBuffers, this.timestampFormatters, this.decimalFormatters);
        connection.addSearchEntryTransformer(h2);
        JSONBuffer buffer = h2.getConnectionHeader("connect");
        Socket s2 = connection.getSocket();
        buffer.appendString("from-address", s2.getInetAddress().getHostAddress());
        buffer.appendNumber("from-port", s2.getPort());
        buffer.appendString("to-address", s2.getLocalAddress().getHostAddress());
        buffer.appendNumber("to-port", s2.getLocalPort());
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return h2;
    }

    @Override
    public void closeInstance() {
        JSONBuffer buffer = this.getConnectionHeader("disconnect");
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        this.requestHandler.closeInstance();
    }

    @Override
    public void processAbandonRequest(int messageID, AbandonRequestProtocolOp request, List<Control> controls) {
        JSONBuffer buffer = this.getRequestHeader("abandon", this.nextOperationID.incrementAndGet(), messageID);
        buffer.appendNumber("id-to-abandon", request.getIDToAbandon());
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        this.requestHandler.processAbandonRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("add", opID, messageID);
        buffer.appendString("dn", request.getDN());
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processAddRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        AddResponseProtocolOp protocolOp = responseMessage.getAddResponseProtocolOp();
        this.generateResponse(buffer, "add", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("bind", opID, messageID);
        buffer.appendNumber("ldap-version", request.getVersion());
        buffer.appendString("dn", request.getBindDN());
        switch (request.getCredentialsType()) {
            case -128: {
                buffer.appendString("authentication-type", "simple");
                break;
            }
            case -93: {
                buffer.appendString("authentication-type", "sasl");
                buffer.appendString("sasl-mechanism", request.getSASLMechanism());
            }
        }
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processBindRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        BindResponseProtocolOp protocolOp = responseMessage.getBindResponseProtocolOp();
        this.generateResponse(buffer, "bind", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("compare", opID, messageID);
        buffer.appendString("dn", request.getDN());
        buffer.appendString("attribute-type", request.getAttributeName());
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processCompareRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        CompareResponseProtocolOp protocolOp = responseMessage.getCompareResponseProtocolOp();
        this.generateResponse(buffer, "compare", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("delete", opID, messageID);
        buffer.appendString("dn", request.getDN());
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processDeleteRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        DeleteResponseProtocolOp protocolOp = responseMessage.getDeleteResponseProtocolOp();
        this.generateResponse(buffer, "delete", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("extended", opID, messageID);
        buffer.appendString("request-oid", request.getOID());
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processExtendedRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ExtendedResponseProtocolOp protocolOp = responseMessage.getExtendedResponseProtocolOp();
        this.generateResponse(buffer, "extended", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        String responseOID = protocolOp.getResponseOID();
        if (responseOID != null) {
            buffer.appendString("response-oid", responseOID);
        }
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("modify", opID, messageID);
        buffer.appendString("dn", request.getDN());
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processModifyRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ModifyResponseProtocolOp protocolOp = responseMessage.getModifyResponseProtocolOp();
        this.generateResponse(buffer, "modify", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("modify-dn", opID, messageID);
        buffer.appendString("dn", request.getDN());
        buffer.appendString("new-rdn", request.getNewRDN());
        buffer.appendBoolean("delete-old-rdn", request.deleteOldRDN());
        String newSuperior = request.getNewSuperiorDN();
        if (newSuperior != null) {
            buffer.appendString("new-superior", newSuperior);
        }
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processModifyDNRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ModifyDNResponseProtocolOp protocolOp = responseMessage.getModifyDNResponseProtocolOp();
        this.generateResponse(buffer, "modify-dn", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        JSONBuffer buffer = this.getRequestHeader("search", opID, messageID);
        buffer.appendString("base", request.getBaseDN());
        buffer.appendNumber("scope", request.getScope().intValue());
        buffer.appendString("filter", request.getFilter().toString());
        buffer.beginArray("requested-attributes");
        for (String requestedAttribute : request.getAttributes()) {
            buffer.appendString(requestedAttribute);
        }
        buffer.endArray();
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        AtomicLong entryCounter = new AtomicLong(0L);
        this.entryCounts.put(messageID, entryCounter);
        try {
            long startTimeNanos = System.nanoTime();
            LDAPMessage responseMessage = this.requestHandler.processSearchRequest(messageID, request, controls);
            long eTimeNanos = System.nanoTime() - startTimeNanos;
            SearchResultDoneProtocolOp protocolOp = responseMessage.getSearchResultDoneProtocolOp();
            this.generateResponse(buffer, "search", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
            buffer.appendNumber("entries-returned", entryCounter.get());
            buffer.endObject();
            this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
            this.logHandler.flush();
            LDAPMessage lDAPMessage = responseMessage;
            return lDAPMessage;
        }
        finally {
            this.entryCounts.remove(messageID);
        }
    }

    @Override
    public void processUnbindRequest(int messageID, UnbindRequestProtocolOp request, List<Control> controls) {
        JSONBuffer buffer = this.getRequestHeader("unbind", this.nextOperationID.getAndIncrement(), messageID);
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        this.logHandler.flush();
        this.requestHandler.processUnbindRequest(messageID, request, controls);
    }

    private JSONBuffer getBuffer() {
        JSONBuffer buffer = this.jsonBuffers.get();
        if (buffer == null) {
            buffer = new JSONBuffer();
            this.jsonBuffers.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    private void addTimestamp(JSONBuffer buffer) {
        SimpleDateFormat timestampFormatter = this.timestampFormatters.get();
        if (timestampFormatter == null) {
            timestampFormatter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSS'Z'");
            timestampFormatter.setTimeZone(StaticUtils.getUTCTimeZone());
            this.timestampFormatters.set(timestampFormatter);
        }
        buffer.appendString("timestamp", timestampFormatter.format(new Date()));
    }

    private JSONBuffer getConnectionHeader(String messageType) {
        JSONBuffer buffer = this.getBuffer();
        buffer.beginObject();
        this.addTimestamp(buffer);
        buffer.appendString("message-type", messageType);
        buffer.appendNumber("connection-id", this.clientConnection.getConnectionID());
        return buffer;
    }

    private JSONBuffer getRequestHeader(String opType, long opID, int msgID) {
        JSONBuffer buffer = this.getBuffer();
        buffer.beginObject();
        this.addTimestamp(buffer);
        buffer.appendString("message-type", "request");
        buffer.appendString("operation-type", opType);
        buffer.appendNumber("connection-id", this.clientConnection.getConnectionID());
        buffer.appendNumber("operation-id", opID);
        buffer.appendNumber("message-id", msgID);
        return buffer;
    }

    private void generateResponse(JSONBuffer buffer, String opType, long opID, int msgID, int resultCode, String diagnosticMessage, String matchedDN, List<String> referralURLs, long eTimeNanos) {
        DecimalFormat decimalFormat;
        buffer.clear();
        buffer.beginObject();
        this.addTimestamp(buffer);
        buffer.appendString("message-type", "response");
        buffer.appendString("operation-type", opType);
        buffer.appendNumber("connection-id", this.clientConnection.getConnectionID());
        buffer.appendNumber("operation-id", opID);
        buffer.appendNumber("message-id", msgID);
        buffer.appendNumber("result-code-value", resultCode);
        ResultCode rc = ResultCode.valueOf(resultCode, null, false);
        if (rc != null) {
            buffer.appendString("result-code-name", rc.getName());
        }
        if (diagnosticMessage != null) {
            buffer.appendString("diagnostic-message", diagnosticMessage);
        }
        if (matchedDN != null) {
            buffer.appendString("matched-dn", matchedDN);
        }
        if (!referralURLs.isEmpty()) {
            buffer.beginArray("referral-urls");
            for (String url : referralURLs) {
                buffer.appendString(url);
            }
            buffer.endArray();
        }
        if ((decimalFormat = this.decimalFormatters.get()) == null) {
            decimalFormat = new DecimalFormat("0.000");
            this.decimalFormatters.set(decimalFormat);
        }
        double eTimeMillis = (double)eTimeNanos / 1000000.0;
        buffer.appendNumber("processing-time-millis", decimalFormat.format(eTimeMillis));
    }

    @Override
    public ObjectPair<SearchResultEntryProtocolOp, Control[]> transformEntry(int messageID, SearchResultEntryProtocolOp entry, Control[] controls) {
        AtomicLong l = this.entryCounts.get(messageID);
        if (l != null) {
            l.incrementAndGet();
        }
        return new ObjectPair<SearchResultEntryProtocolOp, Control[]>(entry, controls);
    }
}

