/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.AbstractDao;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.database.DatabaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDao
extends AbstractDao<User> {
    private static final Logger log = LoggerFactory.getLogger(UserDao.class);

    public UserDao() {
        this.setTableName("users");
        this.setTClass(User.class);
    }

    public List<User> getAll() {
        return this.getObjectsFromResultSet("SELECT * FROM users");
    }

    public Optional<User> getByUsername(String username) {
        return this.getFirstObjectFromResultSet("SELECT * FROM users WHERE username = ?", username);
    }

    public List<User> getByJamiId(String jamiId) {
        return this.getObjectsFromResultSet("SELECT * FROM users WHERE jamiId = ?", jamiId);
    }

    @Override
    public boolean storeObject(User object) {
        String query = "INSERT INTO users (username, password, userType, realm, ethAddress, ethKey, jamiId, certificate, privatekey, accessLevel, needsPasswordReset, salt)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        return this.executeInsert(query, (DatabaseObject)object);
    }

    public boolean updateUserCertificate(String username, String certificate) {
        String query = "UPDATE users SET certificate = ? WHERE username = ?";
        return this.executeUpdate(query, List.of(certificate, username));
    }

    public boolean updateObject(String password, String username) {
        String query = "UPDATE users SET password = ?, needsPasswordReset = 'true' WHERE username = ?";
        return this.executeUpdate(query, List.of(password, username));
    }

    public boolean updateObject(String password, String salt, String username) {
        String query = "UPDATE users SET password = ?, salt = ? WHERE username = ?";
        return this.executeUpdate(query, List.of(password, salt, username));
    }
}

