/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.conversations.Conversation;
import net.jami.jams.common.objects.conversations.ConversationRequest;
import net.jami.jams.common.serialization.database.DatabaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationRequestDao
extends AbstractDao<ConversationRequest> {
    private static final Logger log = LoggerFactory.getLogger(ConversationRequestDao.class);

    public ConversationRequestDao() {
        this.setTableName("conversations");
        this.setTClass(ConversationRequest.class);
    }

    public List<ConversationRequest> getByOwner(String owner) {
        return this.getObjectsFromResultSet("SELECT * FROM conversation_requests WHERE owner = ?", owner);
    }

    @Override
    public boolean storeObject(ConversationRequest object) {
        String query = "INSERT INTO conversation_requests (owner, conversationId, sender, metadatas, received, declined) VALUES (?, ?, ?, ?, ?, ?)";
        return this.executeInsert(query, (DatabaseObject)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeConversationRequestList(List<ConversationRequest> conversationRequestList) {
        if (conversationRequestList.isEmpty()) {
            log.error("Unable to store empty conversationRequest list");
            return false;
        }
        SQLConnection connection = DataStore.connectionPool.getConnection();
        if (connection == null) {
            return false;
        }
        try {
            connection.getConnection().setAutoCommit(false);
            String update = "UPDATE conversation_requests SET sender = ?, metadatas = ?, received = ?, declined = ?WHERE owner = ? AND conversationId = ?";
            String insert = "INSERT INTO conversation_requests (owner, conversationId, sender, metadatas, received, declined) VALUES (?, ?, ?, ?, ?, ?)";
            for (ConversationRequest conversationRequest : conversationRequestList) {
                PreparedStatement updatePs = connection.getConnection().prepareStatement(update);
                try {
                    conversationRequest.getUpdate(updatePs);
                    int rowsUpdated = updatePs.executeUpdate();
                    if (rowsUpdated != 0) continue;
                    PreparedStatement insertPs = connection.getConnection().prepareStatement(insert);
                    try {
                        conversationRequest.getInsert(insertPs);
                        insertPs.executeUpdate();
                    }
                    finally {
                        if (insertPs == null) continue;
                        insertPs.close();
                    }
                }
                finally {
                    if (updatePs == null) continue;
                    updatePs.close();
                }
            }
            connection.getConnection().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Unable to update conversationRequests: {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConversationRequest> filterConversationRequests(List<ConversationRequest> conversationRequestList, List<Conversation> conversationList) {
        ArrayList<ConversationRequest> filteredConversationRequest = new ArrayList<ConversationRequest>();
        if (conversationRequestList.isEmpty()) {
            log.error("Unable to filter empty conversationRequest list");
            return filteredConversationRequest;
        }
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            for (ConversationRequest conversationRequest : conversationRequestList) {
                boolean conversationRequestDeleted = false;
                for (Conversation conversation : conversationList) {
                    if (!conversationRequest.getConversationId().equals(conversation.getId()) || !conversationRequest.getOwner().equals(conversation.getOwner())) continue;
                    String delete = "DELETE FROM conversation_requests WHERE owner = ? AND conversationId = ?";
                    connection.getConnection().setAutoCommit(false);
                    try (PreparedStatement deletePs = connection.getConnection().prepareStatement(delete);){
                        conversationRequest.getDelete(deletePs);
                        deletePs.executeUpdate();
                    }
                    conversationRequestDeleted = true;
                    break;
                }
                if (conversationRequestDeleted) continue;
                filteredConversationRequest.add(conversationRequest);
            }
            connection.getConnection().commit();
        }
        catch (Exception e) {
            log.error("Unable to delete conversationRequests: {}", (Object)e.getMessage());
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
        return filteredConversationRequest;
    }
}

