/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.update;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.updater.FileDescription;
import net.jami.jams.server.licensing.LicenseService;
import net.jami.jams.server.update.JAMSUpdater;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDownloader {
    private static final Logger log = LoggerFactory.getLogger(UpdateDownloader.class);
    private SSLContext sslContext;
    private static final String KEYSTORE_TYPE = "JKS";
    private static volatile String UPDATE_SERVER_URL;
    private final HashMap<String, FileDescription> remoteChecksums = new HashMap();
    private final Gson gson = GsonFactory.createGson();

    public UpdateDownloader() {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("oem/config.json");
        if (input == null) {
            log.warn("Missing OEM configuration! Please contact software developer.");
            System.exit(-1);
        }
        InputStreamReader reader = new InputStreamReader(input);
        JsonObject jsonObject = this.gson.fromJson((Reader)reader, JsonObject.class);
        UPDATE_SERVER_URL = jsonObject.get("UPDATE_URL").getAsString();
    }

    public boolean downloadFiles(HashMap<String, FileDescription> files) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(KEYSTORE_TYPE);
            ks.load(null);
            LicenseService licenseService = new LicenseService();
            licenseService.loadLicense();
            ks.setKeyEntry("licenses", JAMSUpdater.privateKey, "".toCharArray(), new Certificate[]{JAMSUpdater.certificate});
            this.sslContext = SSLContexts.createSystemDefault();
        }
        catch (Exception e) {
            log.warn("An error occurred while downloading the update: " + e);
        }
        File tmpFolder = new File(System.getProperty("user.dir") + "/tmp/");
        if (!tmpFolder.exists()) {
            try {
                tmpFolder.mkdirs();
            }
            catch (Exception e) {
                log.error("An error occurred while creating folder: " + e);
                return false;
            }
        }
        files.forEach((k, v) -> {
            try {
                CloseableHttpClient httpClient;
                HttpResponse httpResponse;
                File tmpFile = new File(System.getProperty("user.dir") + "/tmp/" + v.getFileName());
                if (tmpFile.exists()) {
                    try {
                        tmpFile.delete();
                    }
                    catch (Exception e) {
                        log.warn("An error occurred while deleting file: " + v.getFileName() + " with error " + e);
                    }
                }
                if ((httpResponse = (httpClient = HttpClients.custom().setSSLContext(this.sslContext).build()).execute(new HttpGet(UPDATE_SERVER_URL + "/updates/" + v.getFileName()))).getStatusLine().getStatusCode() != 200) {
                    return;
                }
                FileOutputStream fos = new FileOutputStream(tmpFolder.getPath() + "/" + v.getFileName());
                httpResponse.getEntity().writeTo(fos);
                fos.close();
            }
            catch (Exception e1) {
                log.warn("An error occurred while downloading the update: " + e1);
            }
        });
        return true;
    }
}

