/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.update;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.updater.FileDescription;
import net.jami.jams.common.utils.VersioningUtils;
import net.jami.jams.server.update.JAMSUpdater;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(UpdateCheckTask.class);
    private HashMap<String, FileDescription> remoteData = new HashMap();
    private HashMap<String, FileDescription> localData = new HashMap();
    private SSLContext sslContext;
    private volatile KeyStore trustStore;
    protected static volatile String UPDATE_SERVER_URI;
    private final Gson gson = GsonFactory.createGson();

    protected UpdateCheckTask() {
        try {
            this.sslContext = SSLContexts.createSystemDefault();
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("oem/config.json");
            InputStreamReader reader = new InputStreamReader(input);
            JsonObject jsonObject = this.gson.fromJson((Reader)reader, JsonObject.class);
            UPDATE_SERVER_URI = jsonObject.get("UPDATE_URL").getAsString();
        }
        catch (Exception e) {
            log.error("An error occurred while initializing the trust store: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            this.localData = VersioningUtils.checkVersion(null);
            this.getLatestVersion();
            this.localData.forEach((k, v) -> {
                if (this.remoteData.containsKey(k) && this.remoteData.get(k).compareTo(v) > 0) {
                    log.info("Detected a new version on SFL servers!");
                    JAMSUpdater.updateAvailable.set(true);
                }
            });
        }
        catch (Exception e) {
            log.error("An error occurred while checking for updates: {}", (Object)e.getMessage());
        }
    }

    private void getLatestVersion() {
        try {
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(this.sslContext).build();
            HttpResponse response = httpClient.execute(new HttpGet(UPDATE_SERVER_URI + "/versions.json"));
            byte[] bytes = response.getEntity().getContent().readAllBytes();
            JsonObject jsonObject = this.gson.fromJson(new String(bytes), JsonObject.class);
            jsonObject.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
                String version = value.get("version").getAsString();
                String filename = value.get("filename").getAsString();
                String md5 = value.get("md5").getAsString();
                this.remoteData.put(key, new FileDescription(filename, version, md5, key));
            });
        }
        catch (Exception e) {
            log.warn("An error occurred while establishing connection to JAMS Update Center: " + e);
        }
    }

    public HashMap<String, FileDescription> getRemoteData() {
        return this.remoteData;
    }

    public HashMap<String, FileDescription> getLocalData() {
        return this.localData;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setRemoteData(HashMap<String, FileDescription> remoteData) {
        this.remoteData = remoteData;
    }

    public void setLocalData(HashMap<String, FileDescription> localData) {
        this.localData = localData;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }
}

