/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.user;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.bouncycastle.cert.X509CRLHolder;

@WebServlet(value={"/api/auth/user"})
public class UserServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getAttribute("username").toString();
        Optional<User> result = Server.dataStore.getUserDao().getByUsername(username);
        if (result.isEmpty()) {
            resp.sendError(404, "User was not found!");
            return;
        }
        User user = result.get();
        if (Server.certificateAuthority.getLatestCRL().get() != null) {
            user.setRevoked(Boolean.valueOf(((X509CRLHolder)Server.certificateAuthority.getLatestCRL().get()).getRevokedCertificate(user.getCertificate().getSerialNumber()) != null));
        } else {
            user.setRevoked(Boolean.valueOf(false));
        }
        resp.setStatus(200);
        resp.getOutputStream().write(this.gson.toJson(user).getBytes());
        resp.flushBuffer();
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getAttribute("username").toString();
        User user = Server.dataStore.getUserDao().getByUsername(username).orElseThrow();
        if (user.getUserType() != AuthenticationSourceType.LOCAL) {
            resp.sendError(403, "Unable to change user data as user is not a local user.");
            return;
        }
        String password = req.getParameter("password");
        if (Server.dataStore.getUserDao().updateObject(password, username)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "An error occurred while attempting to update the user's data field.");
        }
    }
}

