/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.authmodule;

import net.jami.jams.authmodule.UserAuthenticationModule;
import net.jami.jams.common.jami.NameRegistrationRequest;
import net.jami.jams.common.jami.NameServer;
import net.jami.jams.common.objects.roots.X509Fields;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.dht.DeviceReceiptGenerator;
import net.jami.jams.dht.ETHAddressGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterUserFlow {
    private static final Logger log = LoggerFactory.getLogger(RegisterUserFlow.class);

    public static boolean createUser(User user, NameServer nameServer) {
        user.setX509Fields(new X509Fields());
        user.getX509Fields().setCommonName(user.getUsername());
        user = UserAuthenticationModule.certificateAuthority.getSignedCertificate(user);
        String[] ethKeyPair = null;
        try {
            ethKeyPair = ETHAddressGenerator.generateAddress();
        }
        catch (Exception e) {
            log.error("Failed to generate an Ethereum key pair for the user " + user.getUsername());
            e.printStackTrace();
            return false;
        }
        user.setEthAddress(ethKeyPair[0]);
        user.setEthKey(ethKeyPair[1]);
        user.setJamiId(DeviceReceiptGenerator.generateJamiId(user));
        NameRegistrationRequest nameRegistrationRequest = new NameRegistrationRequest();
        nameRegistrationRequest.setOwner(ethKeyPair[0]);
        nameRegistrationRequest.setAddr(user.getJamiId());
        if (nameServer != null && nameServer.registerName(user.getUsername(), nameRegistrationRequest) != 200) {
            return false;
        }
        UserAuthenticationModule.datastore.getUserDao().storeObject(user);
        log.info("Created the user " + user.getUsername() + " because he did not exist before!");
        return true;
    }
}

