/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ad.connector.service;

import com.imperva.ddc.core.Connector;
import com.imperva.ddc.core.language.PhraseOperator;
import com.imperva.ddc.core.language.QueryAssembler;
import com.imperva.ddc.core.language.Sentence;
import com.imperva.ddc.core.language.SentenceOperator;
import com.imperva.ddc.core.query.DirectoryType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.EntityResponse;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldType;
import com.imperva.ddc.core.query.ObjectType;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.QueryResponse;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.jami.datastore.main.DataStore;
import net.jami.jams.ad.connector.ADConnector;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.server.core.workflows.RevokeUserFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileService {
    private static final Logger log = LoggerFactory.getLogger(UserProfileService.class);
    private static DataStore dataStore;
    private static final ConcurrentHashMap<String, String> fieldMap;

    public UserProfileService(DataStore dataStore) {
        UserProfileService.dataStore = dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserProfile> getUserProfile(String queryString, String field, boolean exactMatch, Optional<Integer> page) {
        Endpoint endpoint = ADConnector.getConnection();
        try {
            List<UserProfile> list;
            Serializable serializable;
            QueryResponse queryResponse;
            QueryRequest queryRequest = UserProfileService.buildRequest(endpoint);
            Sentence sentence = null;
            if (queryString.equals("*")) {
                sentence = new QueryAssembler().addPhrase(FieldType.OBJECT_CLASS, PhraseOperator.EQUAL, ObjectType.USER.toString()).closeSentence();
            } else {
                if (field.equals("LOGON_NAME")) {
                    sentence = exactMatch ? new QueryAssembler().addPhrase(FieldType.LOGON_NAME, PhraseOperator.EQUAL, queryString).closeSentence() : new QueryAssembler().addPhrase(FieldType.LOGON_NAME, PhraseOperator.CONTAINS, queryString).closeSentence();
                }
                if (field.equals("FULL_TEXT_NAME")) {
                    sentence = new QueryAssembler().addPhrase(FieldType.FIRST_NAME, PhraseOperator.CONTAINS, queryString).addPhrase(FieldType.LAST_NAME, PhraseOperator.CONTAINS, queryString).closeSentence(SentenceOperator.OR);
                }
            }
            queryRequest.addSearchSentence(sentence);
            try (Connector connector = new Connector(queryRequest);){
                queryResponse = connector.execute();
            }
            List results = queryResponse.getAll().stream().map(EntityResponse::getValue).collect(Collectors.toList());
            DataStore.NUM_PAGES = Integer.valueOf(results.size()) / DataStore.RESULTS_PER_PAGE;
            if (results.size() % DataStore.RESULTS_PER_PAGE != 0) {
                serializable = DataStore.NUM_PAGES;
                DataStore.NUM_PAGES = DataStore.NUM_PAGES + 1;
                list = DataStore.NUM_PAGES;
            }
            if (page.isPresent() && !results.isEmpty()) {
                results = results.size() < DataStore.RESULTS_PER_PAGE ? results.subList(0, results.size()) : (page.get() * DataStore.RESULTS_PER_PAGE > results.size() ? results.subList((page.get() - 1) * DataStore.RESULTS_PER_PAGE, results.size()) : results.subList((page.get() - 1) * DataStore.RESULTS_PER_PAGE, page.get() * DataStore.RESULTS_PER_PAGE));
            }
            if (results.size() == 0) {
                serializable = new ArrayList();
                return serializable;
            }
            List<UserProfile> profilesFromResponse = results.stream().map(UserProfileService::profileFromResponse).collect(Collectors.toList());
            for (UserProfile p : profilesFromResponse) {
                dataStore.getUserProfileDao().insertIfNotExists(p);
            }
            list = profilesFromResponse;
            return list;
        }
        catch (Exception e) {
            log.error("An error occurred while attempting to find the entity with the specified parameters.");
            List<UserProfile> list = null;
            return list;
        }
        finally {
            ADConnector.returnConnection(endpoint);
        }
    }

    public static QueryRequest buildRequest(final Endpoint endpoint) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
        queryRequest.setEndpoints((List<Endpoint>)new ArrayList<Endpoint>(){
            {
                this.add(endpoint);
            }
        });
        queryRequest.setSizeLimit(1000);
        queryRequest.setTimeLimit(1000);
        queryRequest.setObjectType(ObjectType.USER);
        for (String field : fieldMap.keySet()) {
            queryRequest.addRequestedField(field);
        }
        return queryRequest;
    }

    public static UserProfile profileFromResponse(List<Field> fields) {
        fieldMap.forEach((k, v) -> {
            String temp = v;
            fieldMap.put(k.toLowerCase(), temp);
        });
        fieldMap.forEach((k, v) -> {
            char[] charArray = k.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                if (!Character.isUpperCase(charArray[i])) continue;
                fieldMap.remove(k);
                break;
            }
        });
        try {
            UserProfile userProfile = new UserProfile();
            for (Field field : fields) {
                if (!fieldMap.containsKey(field.getName())) continue;
                ((Method)UserProfile.exposedMethods.get("set" + fieldMap.get(field.getName()))).invoke((Object)userProfile, field.getValue());
            }
            return userProfile;
        }
        catch (Exception e) {
            log.error("An error occurred while invoking methods: " + e);
            return null;
        }
    }

    public void synchronizeUsersWithAD() {
        log.info("Synchronizing Active Directory user profiles");
        List<UserProfile> profilesFromAD = this.getUserProfile("*", "LOGON_NAME", false, Optional.empty());
        if (profilesFromAD != null && !profilesFromAD.isEmpty()) {
            List<UserProfile> profilesFromDatabase = dataStore.getUserProfileDao().getAllUserProfile();
            for (UserProfile p : profilesFromDatabase) {
                if (!profilesFromAD.stream().noneMatch(r -> r.getUsername().equals(p.getUsername()))) continue;
                log.info("Revoking user " + p.getUsername() + " from the database.");
                RevokeUserFlow.revokeUser(p.getUsername());
                dataStore.getUserProfileDao().deleteUserProfile(p.getUsername());
            }
        }
    }

    static {
        fieldMap = ADConnector.settings.getFieldMappings();
    }
}

