/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.query;

import com.imperva.ddc.core.query.AddModificationDetails;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldType;
import com.imperva.ddc.core.query.ModificationDetails;
import com.imperva.ddc.core.query.RemoveModificationDetails;
import com.imperva.ddc.core.query.ReplaceModificationDetails;
import com.imperva.ddc.core.query.Request;
import java.util.ArrayList;
import java.util.List;

public class ChangeRequest
extends Request {
    private List<ModificationDetails> modificationDetailsList = new ArrayList<ModificationDetails>();
    private String dn;
    private Endpoint endpoint;

    public ChangeRequest(String dn) {
        this.dn = dn;
    }

    public ChangeRequest add(String dn, FieldType fieldType, String value) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new AddModificationDetails(dn, field, value));
        return this;
    }

    public ChangeRequest remove(String dn, FieldType fieldType) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new RemoveModificationDetails(dn, field));
        return this;
    }

    public ChangeRequest replace(String dn, FieldType fieldType, String value) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new ReplaceModificationDetails(dn, field, value));
        return this;
    }

    public ChangeRequest add(FieldType fieldType, String value) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new AddModificationDetails(this.dn, field, value));
        return this;
    }

    public ChangeRequest remove(FieldType fieldType) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new RemoveModificationDetails(this.dn, field));
        return this;
    }

    public ChangeRequest replace(FieldType fieldType, String value) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new ReplaceModificationDetails(this.dn, field, value));
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public List<ModificationDetails> getModificationDetailsList() {
        return this.modificationDetailsList;
    }

    public void setModificationDetailsList(List<ModificationDetails> modificationDetailsList) {
        this.modificationDetailsList = modificationDetailsList;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    @Override
    public void close() {
        if (this.endpoint != null) {
            this.endpoint.close();
            this.endpoint.setLdapConnection(null);
            this.endpoint.setDestinationType(DestinationType.NONE);
        }
    }
}

