/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.Executor;
import com.imperva.ddc.core.exceptions.InvalidExecuteException;
import com.imperva.ddc.core.language.changeCreteria.ChangeCriteria;
import com.imperva.ddc.core.language.searchcriteria.RequestBridgeBuilderDirector;
import com.imperva.ddc.core.language.searchcriteria.RequestBridgeBuilderDirectorImpl;
import com.imperva.ddc.core.language.searchcriteria.SearchCriteria;
import com.imperva.ddc.core.query.AddCriteria;
import com.imperva.ddc.core.query.AddRequest;
import com.imperva.ddc.core.query.ChangeRequest;
import com.imperva.ddc.core.query.ConnectionResponse;
import com.imperva.ddc.core.query.Cursor;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.QueryResponse;
import com.imperva.ddc.core.query.RemoveCriteria;
import com.imperva.ddc.core.query.RemoveRequest;
import com.imperva.ddc.core.query.RequestType;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connector
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connector.class.getName());
    private Executor executor = new Executor();
    private QueryRequest queryRequest;
    private ChangeRequest changeRequest;
    private RemoveRequest removeRequest;
    private AddRequest addRequest;
    private RequestType requestType;

    public Connector(QueryRequest queryRequest) {
        this.setRequest(queryRequest);
    }

    public Connector(ChangeRequest changeRequest) {
        this.setRequest(changeRequest);
    }

    public Connector(RemoveRequest removeRequest) {
        this.setRequest(removeRequest);
    }

    public Connector(AddRequest addRequest) {
        this.setRequest(addRequest);
    }

    public void setRequest(QueryRequest queryRequest) {
        this.queryRequest = queryRequest;
        this.requestType = RequestType.QUERY;
    }

    public void setRequest(AddRequest addRequest) {
        this.addRequest = addRequest;
        this.requestType = RequestType.ADD;
    }

    public void setRequest(ChangeRequest changeRequest) {
        this.changeRequest = changeRequest;
        this.requestType = RequestType.CHANGE;
    }

    public void setRequest(RemoveRequest removeRequest) {
        this.removeRequest = removeRequest;
        this.requestType = RequestType.REMOVE;
    }

    public Cursor getCursor() {
        if (this.requestType == RequestType.QUERY) {
            if (!this.queryRequest.isPaged()) {
                throw new InvalidParameterException("Chunk Size in not configured, paging can't be handled");
            }
            Cursor cursor = new Cursor(this);
            for (Endpoint endPoint : this.queryRequest.getEndpoints()) {
                cursor.addEndpoint(endPoint);
            }
            return cursor;
        }
        return null;
    }

    public QueryResponse execute() {
        if (this.requestType != RequestType.QUERY) {
            throw new InvalidExecuteException("The ChangeRequest object in the connector class doesn't match with the execute() method");
        }
        RequestBridgeBuilderDirectorImpl builderManager = this.searchCriteriaBridgeBuilderDirectorImplGetInstance();
        this.validateRequest(this.queryRequest);
        ((RequestBridgeBuilderDirector)builderManager).build(this.queryRequest);
        SearchCriteria searchCriteria = (SearchCriteria)((RequestBridgeBuilderDirector)builderManager).get();
        LOGGER.debug("Ldap Query: " + searchCriteria.toString());
        this.queryRequest.setRequestedFields(searchCriteria.getRequestedFields());
        this.queryRequest.setSearchSentenceText(searchCriteria.getSearchFilter());
        return this.executor.execute(this.queryRequest);
    }

    public void executeChangeRequest() {
        if (this.requestType != RequestType.CHANGE) {
            throw new InvalidExecuteException("The queryRequest object in the connector class doesn't match with the executeChangeRequest() method");
        }
        RequestBridgeBuilderDirectorImpl builderManager = this.searchCriteriaBridgeBuilderDirectorImplGetInstance();
        this.validateRequest(this.changeRequest);
        ((RequestBridgeBuilderDirector)builderManager).build(this.changeRequest);
        ChangeCriteria changeCriteria = (ChangeCriteria)((RequestBridgeBuilderDirector)builderManager).get();
        this.changeRequest.setModificationDetailsList(changeCriteria.getModificationDetailsList());
        this.executor.execute(this.changeRequest);
    }

    public void executeRemoveRequest() {
        if (this.requestType != RequestType.REMOVE) {
            throw new InvalidExecuteException("The queryRequest object in the connector class doesn't match with the executeRemoveRequest() method");
        }
        RequestBridgeBuilderDirectorImpl builderManager = this.searchCriteriaBridgeBuilderDirectorImplGetInstance();
        ((RequestBridgeBuilderDirector)builderManager).build(this.removeRequest);
        RemoveCriteria removeCriteria = (RemoveCriteria)((RequestBridgeBuilderDirector)builderManager).get();
        this.removeRequest.setDn(removeCriteria.getTranslatedDN());
        this.executor.execute(this.removeRequest);
    }

    public void executeAddequest() {
        if (this.requestType != RequestType.ADD) {
            throw new InvalidExecuteException("The queryRequest object in the connector class doesn't match with the executeAddRequest() method");
        }
        RequestBridgeBuilderDirectorImpl builderManager = this.searchCriteriaBridgeBuilderDirectorImplGetInstance();
        ((RequestBridgeBuilderDirector)builderManager).build(this.addRequest);
        AddCriteria addCriteria = (AddCriteria)((RequestBridgeBuilderDirector)builderManager).get();
        this.addRequest.setFields(addCriteria.getFields());
        this.addRequest.setDn(addCriteria.getTranslatedDN());
        this.executor.execute(this.addRequest);
    }

    public ConnectionResponse testConnection() {
        if (this.requestType == RequestType.QUERY) {
            this.validateRequest(this.queryRequest);
            return this.executor.testConnection(this.queryRequest.getEndpoints().get(0));
        }
        return this.executor.testConnection(this.changeRequest.getEndpoint());
    }

    @Override
    public void close() {
        if (this.requestType == RequestType.QUERY) {
            if (this.queryRequest != null) {
                this.queryRequest.close();
            }
        } else if (this.requestType == RequestType.CHANGE) {
            if (this.changeRequest != null) {
                this.changeRequest.close();
            }
        } else if (this.requestType == RequestType.ADD) {
            if (this.addRequest != null) {
                this.addRequest.close();
            }
        } else if (this.requestType == RequestType.REMOVE && this.removeRequest != null) {
            this.removeRequest.close();
        }
    }

    RequestBridgeBuilderDirectorImpl searchCriteriaBridgeBuilderDirectorImplGetInstance() {
        return new RequestBridgeBuilderDirectorImpl();
    }

    void validateRequest(QueryRequest queryRequest) {
        if (this.requestType == RequestType.QUERY) {
            int howManyFailed;
            if (queryRequest.getEndpoints() == null || queryRequest.getEndpoints().isEmpty()) {
                throw new InvalidParameterException("Endpoints are required");
            }
            if (queryRequest.getSizeLimit() < queryRequest.getPageChunkSize()) {
                throw new InvalidParameterException("SizeLimit must be grater than or equal to PageChunkSize");
            }
            if (queryRequest.isIgnoreSSLValidations() != null) {
                queryRequest.getEndpoints().forEach(end -> end.setIgnoreSSLValidations(queryRequest.isIgnoreSSLValidations()));
            }
            if ((howManyFailed = (int)queryRequest.getEndpoints().stream().filter(i -> !i.isValid()).count()) > 0) {
                throw new InvalidParameterException("Critical Endpoint info missing");
            }
        }
    }

    void validateRequest(ChangeRequest changeRequest) {
        if (this.requestType == RequestType.QUERY) {
            if (changeRequest.getEndpoint() == null) {
                throw new InvalidParameterException("Endpoints are required");
            }
            if (changeRequest.isIgnoreSSLValidations() != null) {
                changeRequest.getEndpoint().setIgnoreSSLValidations(changeRequest.isIgnoreSSLValidations());
            }
        }
    }

    public RequestType getRequestType() {
        return this.requestType;
    }
}

