/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.query.AddModificationDetails;
import com.imperva.ddc.core.query.EntityResponse;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.ModificationDetails;
import com.imperva.ddc.core.query.Operation;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.ReferralsHandling;
import com.imperva.ddc.core.query.ReplaceModificationDetails;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheAPIConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheAPIConverter.class.getName());

    ApacheAPIConverter() {
    }

    String[] toStringArray(List<Field> entities) {
        if (entities == null || entities.isEmpty()) {
            String[] result = new String[]{"*"};
            return result;
        }
        String[] result = new String[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            result[i] = entities.get(i).getName();
        }
        return result;
    }

    public Modification toModification(ModificationDetails modificationDetails) {
        Operation operation = modificationDetails.getOperation();
        String strAttribute = modificationDetails.getAttribute().getName();
        switch (operation) {
            case ADD: {
                return new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, strAttribute, ((AddModificationDetails)modificationDetails).getValue());
            }
            case REMOVE: {
                return new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, strAttribute);
            }
            case REPLACE: {
                return new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, strAttribute, ((ReplaceModificationDetails)modificationDetails).getValue());
            }
        }
        return null;
    }

    List<EntityResponse> toEntityResponse(List<Entry> entries, List<Field> requestedFields) {
        ArrayList<EntityResponse> entResponses = new ArrayList<EntityResponse>();
        for (Entry ent : entries) {
            EntityResponse entResponse = new EntityResponse();
            entResponse.setKey(ent.getDn().getName());
            for (Attribute att : ent.getAttributes()) {
                for (Field field : requestedFields) {
                    if (!field.getName().equalsIgnoreCase(att.getId())) continue;
                    att.iterator().forEachRemaining(value -> entResponse.addValue(value.getValue(), att.getId(), field.getType()));
                }
            }
            entResponses.add(entResponse);
        }
        return entResponses;
    }

    SearchRequest toSearchRequest(QueryRequest queryRequest, String baseSearchPath) throws LdapException {
        String searchText;
        SearchRequestImpl search = new SearchRequestImpl();
        search.setScope(SearchScope.SUBTREE);
        String[] translatedRequestedFieldsArray = this.toStringArray(queryRequest.getRequestedFields());
        search.addAttributes(translatedRequestedFieldsArray);
        search.setTimeLimit(queryRequest.getTimeLimit());
        search.setSizeLimit(queryRequest.getSizeLimit().intValue());
        search.setBase(new Dn(baseSearchPath));
        if (queryRequest.getReferralsHandling() == ReferralsHandling.FOLLOW) {
            search.followReferrals();
        } else if (queryRequest.getReferralsHandling() == ReferralsHandling.IGNORE) {
            search.ignoreReferrals();
        }
        String string = searchText = queryRequest.getSearchText() == null ? queryRequest.getSearchSentenceText() : queryRequest.getSearchText();
        if (searchText != null && !searchText.trim().isEmpty()) {
            search.setFilter(searchText);
        }
        return search;
    }

    SearchRequest toSearchRequest(QueryRequest queryRequest, String baseSearchPath, Object cookie) throws LdapException {
        SearchRequest search = this.toSearchRequest(queryRequest, baseSearchPath);
        if (queryRequest.isPaged()) {
            PagedResultsImpl pagedSearchControl = new PagedResultsImpl();
            int size = queryRequest.getPageChunkSize();
            pagedSearchControl.setSize(size);
            pagedSearchControl.setCookie((byte[])cookie);
            pagedSearchControl.setCritical(true);
            search.addControl(pagedSearchControl);
        }
        return search;
    }
}

