/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.dht;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.user.User;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceReceiptGenerator {
    private static final Logger log = LoggerFactory.getLogger(DeviceReceiptGenerator.class);

    private static void packToSign(MessageBufferPacker messagePack, PublicKey publicKey, byte[] deviceId) throws IOException {
        byte[] owner = publicKey.getEncoded();
        messagePack.packMapHeader(4);
        messagePack.packString("seq");
        messagePack.packInt(0);
        messagePack.packString("owner");
        messagePack.packBinaryHeader(owner.length);
        messagePack.addPayload(owner);
        messagePack.packString("type");
        messagePack.packInt(0);
        messagePack.packString("data");
        MessageBufferPacker innerMessagePack = MessagePack.newDefaultBufferPacker();
        innerMessagePack.packMapHeader(1);
        innerMessagePack.packString("dev");
        innerMessagePack.packBinaryHeader(deviceId.length);
        innerMessagePack.addPayload(deviceId);
        messagePack.packBinaryHeader(innerMessagePack.toByteArray().length);
        messagePack.addPayload(innerMessagePack.toByteArray());
    }

    private static byte[] generateAnnoucement(PrivateKey privateKey, PublicKey publicKey, PublicKey devicePubKey) {
        try {
            MessageBufferPacker outerMessagePack = MessagePack.newDefaultBufferPacker();
            MessageBufferPacker messagePack = MessagePack.newDefaultBufferPacker();
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] deviceId = digest.digest(devicePubKey.getEncoded());
            DeviceReceiptGenerator.packToSign(messagePack, publicKey, deviceId);
            byte[] owner = publicKey.getEncoded();
            Signature signer = Signature.getInstance("SHA512withRSA");
            signer.initSign(privateKey);
            signer.update(messagePack.toByteArray());
            byte[] signature = signer.sign();
            outerMessagePack.packMapHeader(2);
            outerMessagePack.packString("id");
            outerMessagePack.packInt(0);
            outerMessagePack.packString("dat");
            outerMessagePack.packMapHeader(2);
            outerMessagePack.packString("body");
            DeviceReceiptGenerator.packToSign(outerMessagePack, publicKey, deviceId);
            outerMessagePack.packString("sig");
            outerMessagePack.packBinaryHeader(signature.length);
            outerMessagePack.addPayload(signature);
            return outerMessagePack.toByteArray();
        }
        catch (Exception e) {
            log.error("An error occurred while building the device receipt.");
            return null;
        }
    }

    public static String[] generateReceipt(PrivateKey privateKey, PublicKey publicKey, PublicKey devicePubKey, String ethAddress) {
        try {
            LinkedHashMap<String, String> receipt = new LinkedHashMap<String, String>(){

                @Override
                public String toString() {
                    return "{" + this.entrySet().stream().map(x -> "\"" + (String)x.getKey() + "\":\"" + (String)x.getValue() + "\"").collect(Collectors.joining(",")) + "}";
                }
            };
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            receipt.put("id", Hex.encodeHexString(digest.digest(publicKey.getEncoded())));
            receipt.put("dev", Hex.encodeHexString(digest.digest(devicePubKey.getEncoded())));
            receipt.put("eth", ethAddress);
            receipt.put("announce", Base64.encodeBase64String(DeviceReceiptGenerator.generateAnnoucement(privateKey, publicKey, devicePubKey)));
            Signature signer = Signature.getInstance("SHA512withRSA");
            signer.initSign(privateKey);
            signer.update(receipt.toString().getBytes());
            byte[] signature = signer.sign();
            return new String[]{receipt.toString(), java.util.Base64.getEncoder().encodeToString(signature)};
        }
        catch (Exception e) {
            log.error("Unable to build generate device receipt!");
            return null;
        }
    }

    public static String generateJamiId(User user) {
        try {
            return Hex.encodeHexString(MessageDigest.getInstance("SHA-1").digest(user.getCertificate().getPublicKey().getEncoded()));
        }
        catch (Exception e) {
            log.error("Unable to generate JamiId with error " + e);
            return null;
        }
    }

    public static String generateDeviceId(Device device) {
        try {
            return Hex.encodeHexString(MessageDigest.getInstance("SHA-256").digest(device.getCertificate().getPublicKey().getEncoded()));
        }
        catch (Exception e) {
            log.error("Unable to generate deviceId with error " + e);
            return null;
        }
    }
}

