/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.authmodule;

import com.nimbusds.jwt.SignedJWT;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jami.datastore.main.DataStore;
import net.jami.jams.authmodule.PasswordUtil;
import net.jami.jams.authmodule.RegisterUserFlow;
import net.jami.jams.authmodule.TokenController;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.authmodule.AuthTokenResponse;
import net.jami.jams.common.authmodule.AuthenticationModule;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.jami.NameServer;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.utils.LibraryLoader;
import net.jami.jams.common.utils.X509Utils;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthenticationModule
implements AuthenticationModule {
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationModule.class);
    private static final String LDAP_CONNECTOR_CLASS = "net.jami.jams.ldap.connector.LDAPConnector";
    private static final String AD_CONNECTOR_CLASS = "net.jami.jams.ad.connector.ADConnector";
    public static DataStore datastore;
    public static CertificateAuthority certificateAuthority;
    private CertificateFactory certificateFactory;
    CertPathValidator certPathValidator;
    private final TokenController tokenController;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private final ConcurrentHashMap<AuthModuleKey, AuthenticationSource> authenticationSources = new ConcurrentHashMap();

    public UserAuthenticationModule(DataStore dataStore, CertificateAuthority certificateAuthority) throws Exception {
        datastore = dataStore;
        UserAuthenticationModule.certificateAuthority = certificateAuthority;
        this.certificateFactory = CertificateFactory.getInstance("X.509");
        this.certPathValidator = CertPathValidator.getInstance("PKIX");
        this.authenticationSources.put(new AuthModuleKey("LOCAL", AuthenticationSourceType.LOCAL), datastore);
        log.info("Started authentication module - default local source is already enabled!");
        File pubkeyFile = new File(System.getProperty("user.dir") + File.separator + "oauth.pub");
        File privateKeyFile = new File(System.getProperty("user.dir") + File.separator + "oauth.key");
        if (!privateKeyFile.exists() || !pubkeyFile.exists()) {
            log.info("Generating first time private/public keys for OAuth!");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(4096);
            KeyPair kp = keyPairGenerator.generateKeyPair();
            this.privateKey = kp.getPrivate();
            this.publicKey = kp.getPublic();
            FileOutputStream os = new FileOutputStream(System.getProperty("user.dir") + File.separator + "oauth.key");
            ((OutputStream)os).write(X509Utils.getPEMStringFromPrivateKey((PrivateKey)this.privateKey).getBytes());
            os.flush();
            ((OutputStream)os).close();
            log.info("OAuth private key stored successfully for future use.");
            os = new FileOutputStream(System.getProperty("user.dir") + File.separator + "oauth.pub");
            ((OutputStream)os).write(X509Utils.getPEMStringFromPubKey((PublicKey)this.publicKey).getBytes());
            os.flush();
            ((OutputStream)os).close();
            log.info("OAuth public key stored successfully for future use.");
        } else {
            FileInputStream privateInput = new FileInputStream(privateKeyFile);
            this.privateKey = X509Utils.getKeyFromPEMString((String)new String(((InputStream)privateInput).readAllBytes()));
            ((InputStream)privateInput).close();
            log.info("OAuth private key loaded successfully.");
            FileInputStream publicInput = new FileInputStream(pubkeyFile);
            this.publicKey = X509Utils.getPubKeyFromPEMString((String)new String(((InputStream)publicInput).readAllBytes()));
            ((InputStream)publicInput).close();
            log.info("OAuth public key loaded successfully.");
        }
        this.tokenController = new TokenController(this.privateKey);
        log.info("OAuth2 Token System instantiated successfully.");
    }

    public void attachAuthSource(AuthenticationSourceType type, String settings) {
        switch (type) {
            case AD: {
                this.loadAuthConnector(AD_CONNECTOR_CLASS, settings);
                break;
            }
            case LDAP: {
                this.loadAuthConnector(LDAP_CONNECTOR_CLASS, settings);
                break;
            }
        }
    }

    private void loadAuthConnector(String className, String settings) {
        try {
            Class cls = LibraryLoader.classLoader.loadClass(className);
            AuthenticationSource source = (AuthenticationSource)cls.getConstructor(String.class, DataStore.class).newInstance(settings, datastore);
            this.authenticationSources.put(new AuthModuleKey(source.getInfo().getRealm(), source.getInfo().getAuthenticationSourceType()), source);
        }
        catch (Exception e) {
            log.error("An error occurred while loading connector " + className + ": " + e);
        }
    }

    public AuthTokenResponse authenticateUser(String username, String password) {
        User user;
        AuthTokenResponse res = null;
        String hashPass = "";
        if (datastore.getUserDao().getByUsername(username).isPresent() && (hashPass = (user = datastore.getUserDao().getByUsername(username).orElseThrow()).getUserType() == AuthenticationSourceType.LOCAL ? PasswordUtil.hashPassword(password, Base64.decodeBase64(user.getSalt())) : password) != null && this.authenticationSources.get(new AuthModuleKey(user.getRealm(), user.getUserType())).authenticate(username, hashPass)) {
            return this.tokenController.getToken(user, null);
        }
        for (AuthModuleKey key : this.authenticationSources.keySet()) {
            if (!this.authenticationSources.get(key).authenticate(username, password)) continue;
            User user2 = new User();
            user2.setUsername(username);
            user2.setAccessLevel(AccessLevel.USER);
            user2.setRealm(key.getRealm());
            user2.setUserType(key.getType());
            RegisterUserFlow.createUser(user2, null);
            return this.tokenController.getToken(user2, null);
        }
        return res;
    }

    public AuthTokenResponse authenticateUser(X509Certificate[] certificates) {
        try {
            ArrayList<X509Certificate> certificatesWithoutRootCA = new ArrayList<X509Certificate>(Arrays.asList(certificates));
            if (!certificatesWithoutRootCA.isEmpty()) {
                X509Certificate lastCert = (X509Certificate)certificatesWithoutRootCA.get(certificatesWithoutRootCA.size() - 1);
                if (UserAuthenticationModule.isSelfSigned(lastCert)) {
                    certificatesWithoutRootCA.remove(lastCert);
                }
            } else {
                return null;
            }
            CertPath certPath = this.certificateFactory.generateCertPath(certificatesWithoutRootCA);
            PKIXParameters pkixParams = new PKIXParameters(Collections.singleton(new TrustAnchor(certificateAuthority.getCA(), null)));
            pkixParams.setRevocationEnabled(false);
            pkixParams.setDate(new Date());
            this.certPathValidator.validate(certPath, pkixParams);
            X509CRLHolder crl = (X509CRLHolder)certificateAuthority.getLatestCRL().get();
            for (X509Certificate certificate : certificatesWithoutRootCA) {
                if (crl.getRevokedCertificate(certificate.getSerialNumber()) == null) continue;
                return null;
            }
            X509Certificate clientCertificate = certificates[1];
            X509Certificate deviceCertificate = certificates[0];
            String username = (String)X509Utils.extractDNFromCertificate((X509Certificate)clientCertificate).get("CN");
            User user = datastore.getUserDao().getByUsername(username).orElseThrow();
            return this.tokenController.getToken(user, (String)X509Utils.extractDNFromCertificate((X509Certificate)deviceCertificate).get("UID"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public AuthTokenResponse authenticateUser(X509Certificate deviceCertificate) {
        try {
            String username = UserAuthenticationModule.getIssuerCN(deviceCertificate);
            User user = datastore.getUserDao().getByUsername(username).orElseThrow();
            return this.tokenController.getToken(user, (String)X509Utils.extractDNFromCertificate((X509Certificate)deviceCertificate).get("UID"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getIssuerCN(X509Certificate certificate) {
        String issuerDN = certificate.getIssuerX500Principal().getName();
        Pattern pattern = Pattern.compile("CN=([^,]+)");
        Matcher matcher = pattern.matcher(issuerDN);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ConcurrentHashMap<AuthModuleKey, AuthenticationSource> getAuthSources() {
        return this.authenticationSources;
    }

    public boolean testModuleConfiguration(AuthenticationSourceType type, String settings) {
        try {
            String className = "";
            if (type.equals((Object)AuthenticationSourceType.AD)) {
                className = AD_CONNECTOR_CLASS;
            }
            if (type.equals((Object)AuthenticationSourceType.LDAP)) {
                className = LDAP_CONNECTOR_CLASS;
            }
            Class cls = LibraryLoader.classLoader.loadClass(className);
            AuthenticationSource source = (AuthenticationSource)cls.getConstructor(String.class, DataStore.class).newInstance(settings, datastore);
            return source.test();
        }
        catch (Exception e) {
            log.error("The testing of the source was unsuccessful: " + e);
            return false;
        }
    }

    public boolean createUser(AuthenticationSourceType type, String realm, NameServer nameServer, User user) {
        return RegisterUserFlow.createUser(user, nameServer);
    }

    public RSAPublicKey getAuthModulePubKey() {
        return (RSAPublicKey)this.publicKey;
    }

    public char[] getOTP(String username) {
        Optional<User> user = datastore.getUserDao().getByUsername(username);
        return user.map(u -> u.getPassword().toCharArray()).orElse(new char[0]);
    }

    public boolean verifyToken(SignedJWT token) {
        return false;
    }

    public void deleteToken(SignedJWT token) {
    }
}

