/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.serialization.database.DatabaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDao<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDao.class);
    private String tableName;
    protected Class<T> tClass;

    public abstract boolean storeObject(T var1);

    protected Optional<T> getFirstObjectFromResultSet(String query) {
        return this.getFirstObjectFromResultSet(query, new ArrayList<String>());
    }

    protected Optional<T> getFirstObjectFromResultSet(String query, String param) {
        return this.getFirstObjectFromResultSet(query, List.of(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<T> getFirstObjectFromResultSet(String query, List<String> params) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        if (connection != null) {
            try (PreparedStatement ps = connection.getConnection().prepareStatement(query);){
                for (int i = 0; i < params.size(); ++i) {
                    ps.setString(i + 1, params.get(i));
                }
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        T obj = this.tClass.getConstructor(ResultSet.class).newInstance(rs);
                        Optional<T> optional = Optional.of(obj);
                        return optional;
                    }
                }
            }
            catch (Exception e) {
                log.error("An error occurred while fetching the first result from the database: ", e);
            }
            finally {
                DataStore.connectionPool.returnConnection(connection);
            }
        }
        return Optional.empty();
    }

    protected List<T> getObjectsFromResultSet(String query) {
        return this.getObjectsFromResultSet(query, new ArrayList<String>());
    }

    protected List<T> getObjectsFromResultSet(String query, String param) {
        return this.getObjectsFromResultSet(query, List.of(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getObjectsFromResultSet(String query, List<String> params) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        ArrayList<T> result = new ArrayList<T>();
        if (connection != null) {
            try (PreparedStatement ps = connection.getConnection().prepareStatement(query);){
                for (int i = 0; i < params.size(); ++i) {
                    ps.setString(i + 1, params.get(i));
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(this.tClass.getConstructor(ResultSet.class).newInstance(rs));
                    }
                }
            }
            catch (Exception e) {
                log.error("An error occurred while fetching results from the database: ", e);
            }
            finally {
                DataStore.connectionPool.returnConnection(connection);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeUpdate(String query, List<String> params) {
        block14: {
            SQLConnection connection = DataStore.connectionPool.getConnection();
            if (connection != null) {
                try {
                    boolean bl;
                    block13: {
                        PreparedStatement ps = connection.getConnection().prepareStatement(query);
                        try {
                            boolean executeUpdate;
                            for (int i = 0; i < params.size(); ++i) {
                                ps.setString(i + 1, params.get(i));
                            }
                            bl = executeUpdate = ps.executeUpdate() != 0;
                            if (ps == null) break block13;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ps != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                log.error("An error occurred while updating: ", e);
                                break block14;
                            }
                        }
                        ps.close();
                    }
                    return bl;
                }
                finally {
                    DataStore.connectionPool.returnConnection(connection);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInsert(String query, DatabaseObject object) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        if (connection != null) {
            try {
                PreparedStatement ps = connection.getConnection().prepareStatement(query);
                ps = object.getInsert(ps);
                boolean executeUpdate = ps.executeUpdate() != 0;
                ps.close();
                boolean bl = executeUpdate;
                return bl;
            }
            catch (Exception e) {
                log.error("An error occurred while inserting: ", e);
            }
            finally {
                DataStore.connectionPool.returnConnection(connection);
            }
        }
        return false;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<T> getTClass() {
        return this.tClass;
    }

    public void setTClass(Class<T> tClass) {
        this.tClass = tClass;
    }
}

