/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import launcher.zmq.MessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

public class AppStarter
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AppStarter.class);
    private final AtomicBoolean doUpdate = new AtomicBoolean(false);
    public static ZMQ.Context context = ZMQ.context(1);
    private static ZMQ.Socket publisher;
    private static ZMQ.Socket receiver;
    private MessageReceiver messageReceiver;
    private static String[] parentArgs;
    private long jamsProcessId = -1L;

    private void setupZmqBridge() {
        publisher = context.socket(SocketType.PUB);
        publisher.bind("tcp://*:4572");
        receiver = context.socket(SocketType.REP);
        receiver.bind("tcp://*:4573");
        this.messageReceiver = new MessageReceiver(receiver, this.doUpdate);
        this.messageReceiver.start();
    }

    private void unpackUpdate() {
        for (File f : Objects.requireNonNull(new File(System.getProperty("user.dir") + "/tmp/").listFiles())) {
            if (f.getName().contains("jams-server")) {
                if (!f.renameTo(new File(System.getProperty("user.dir") + "/" + f.getName()))) {
                    log.info("An error occurred while attempting to move the file!");
                    continue;
                }
                f.delete();
                continue;
            }
            if (!f.renameTo(new File(System.getProperty("user.dir") + "/libs/" + f.getName()))) {
                log.info("An error occurred while attempting to move the file!");
                continue;
            }
            f.delete();
        }
        new File(System.getProperty("user.dir") + "/tmp/").delete();
    }

    public AppStarter(String[] args) {
        parentArgs = args;
        try {
            this.jamsProcessId = AppStarter.startAccountManagementServer(args);
            ProcessHandle jamsProcessHandle = ProcessHandle.of(this.jamsProcessId).orElseThrow(() -> new IllegalArgumentException("No process with PID " + this.jamsProcessId));
            Thread waitForProcessThread = new Thread(() -> {
                try {
                    ((CompletableFuture)jamsProcessHandle.onExit().thenAccept(ph -> {
                        log.info("JAMS has ended prematurely.");
                        System.exit(1);
                    })).get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            waitForProcessThread.start();
            this.setupZmqBridge();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                log.info("Shutting down\u2026");
                ProcessHandle.of(this.jamsProcessId).ifPresentOrElse(process -> process.destroyForcibly(), () -> log.warn("No process with PID " + this.jamsProcessId));
            }));
        }
        catch (Exception e) {
            log.warn("An error occurred while attempting to create and bind publisher and/or receiver. Please contact software developer.");
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        AppStarter appStarter = new AppStarter(args);
        appStarter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.doUpdate.get()) {
                        ProcessHandle.of(this.jamsProcessId).get().destroyForcibly();
                        this.doUpdate.set(false);
                        this.unpackUpdate();
                        this.jamsProcessId = AppStarter.startAccountManagementServer(parentArgs);
                        log.info("Update complete. Now running newest version");
                    }
                    AtomicBoolean atomicBoolean = this.doUpdate;
                    synchronized (atomicBoolean) {
                        this.doUpdate.wait();
                    }
                }
            }
            catch (Exception e) {
                log.error("An error occurred while attempting to verify if an update was available, orwhen attempting to reload a library: {}", (Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    public static long startAccountManagementServer(String[] parentArgs) throws IOException {
        ProcessBuilder pb = null;
        switch (parentArgs.length) {
            case 1: {
                pb = new ProcessBuilder("java", "-jar", "jams-server.jar", parentArgs[0]);
                break;
            }
            case 3: {
                pb = new ProcessBuilder("java", "-Dorg.ldaptive.sortSearchResults=true", "-jar", "jams-server.jar", parentArgs[0], parentArgs[1], parentArgs[2]);
                break;
            }
            default: {
                pb = new ProcessBuilder("java", "-jar", "jams-server.jar", "8080");
            }
        }
        assert (pb != null);
        pb.directory(new File(System.getProperty("user.dir")));
        pb.inheritIO();
        Process p = pb.start();
        return p.pid();
    }

    public AtomicBoolean getDoUpdate() {
        return this.doUpdate;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public long getJamsProcessId() {
        return this.jamsProcessId;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public void setJamsProcessId(long jamsProcessId) {
        this.jamsProcessId = jamsProcessId;
    }
}

