/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.startup;

import net.jami.datastore.main.DataStore;
import net.jami.jams.common.authmodule.AuthenticationModule;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.utils.LibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthModuleLoader {
    private static final Logger log = LoggerFactory.getLogger(AuthModuleLoader.class);

    public static AuthenticationModule loadAuthenticationModule(DataStore dataStore, CertificateAuthority certificateAuthority) {
        try {
            Class<?> cls = LibraryLoader.classLoader.loadClass("net.jami.jams.authmodule.UserAuthenticationModule");
            AuthenticationModule authenticationModule = (AuthenticationModule)cls.getConstructor(DataStore.class, CertificateAuthority.class).newInstance(dataStore, certificateAuthority);
            log.info("Authentication Module loaded successfully.");
            return authenticationModule;
        }
        catch (Exception e) {
            log.error("An error occurred while attempting to load Authentication Module.");
            return null;
        }
    }
}

