/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.filters.FilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/api/auth/*", "/api/admin/*"})
public class DApiFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DApiFilter.class);

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setContentType("application/json;charset=UTF-8");
        if (!Server.isInstalled.get()) {
            TomcatCustomErrorHandler.sendCustomError(response, 404, "Setup has not yet been completed!");
            return;
        }
        boolean authsuccess = false;
        boolean isLogin = false;
        boolean isOCSPCheck = false;
        if (request.getServletPath().contains("login")) {
            isLogin = true;
        } else if (request.getServletPath().contains("ocsp")) {
            isOCSPCheck = true;
        } else {
            authsuccess = FilterUtils.doAuthCheck(request);
        }
        if (authsuccess || isLogin || isOCSPCheck) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        TomcatCustomErrorHandler.sendCustomError(response, 401, "You are not authenticated!");
    }
}

