/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.directory;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Policy;
import net.jami.jams.common.objects.user.PolicyData;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.server.Server;
import org.bouncycastle.cert.X509CRLEntryHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/auth/directory/search"})
public class SearchDirectoryServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SearchDirectoryServlet.class);
    private final Gson gson = GsonFactory.createGson();
    List<UserProfile> userProfiles = new ArrayList<UserProfile>();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pageParam = req.getParameter("page");
        Optional<Object> page = pageParam == null ? Optional.empty() : Optional.ofNullable(Integer.parseInt(pageParam));
        ConcurrentHashMap<AuthModuleKey, AuthenticationSource> authSources = new ConcurrentHashMap<AuthModuleKey, AuthenticationSource>(Server.userAuthenticationModule.getAuthSources());
        String username = req.getAttribute("username").toString();
        try {
            Policy policy = Server.dataStore.getPolicyDao().getByUsername(username).orElseThrow();
            PolicyData policyData = this.gson.fromJson(policy.getPolicyData(), PolicyData.class);
            if (!policyData.getAllowLookup().booleanValue()) {
                resp.sendError(403, "Operation not allowed!");
                return;
            }
        }
        catch (Exception e1) {
            log.warn("No policy available for user - not adding a policy component to response");
        }
        if (authSources.size() > 1) {
            authSources.forEach((k, v) -> {
                if (k.getType() == AuthenticationSourceType.LOCAL) {
                    authSources.remove(k);
                }
            });
        }
        String queryString = req.getParameter("queryString");
        authSources.forEach((k, v) -> {
            if (queryString.equals("*")) {
                this.userProfiles = v.searchUserProfiles(queryString, "FULL_TEXT_NAME", page);
            }
            this.userProfiles = v.searchUserProfiles(queryString, "FULL_TEXT_NAME", page);
            if (this.userProfiles.isEmpty() && this.userProfiles.addAll(v.searchUserProfiles(queryString, "LOGON_NAME", page))) {
                TreeSet<UserProfile> s = new TreeSet<UserProfile>(new Comparator<UserProfile>(){

                    @Override
                    public int compare(UserProfile o1, UserProfile o2) {
                        if (o1.getUsername().equals(o2.getUsername())) {
                            return 0;
                        }
                        return 1;
                    }
                });
                s.addAll(this.userProfiles);
                this.userProfiles = new ArrayList<UserProfile>(s);
            }
            this.userProfiles.forEach(profile -> {
                List results = new ArrayList();
                while (results.isEmpty()) {
                    results = Server.dataStore.getUserDao().getByUsername(profile.getUsername()).map(user -> List.of(user)).orElseGet(() -> List.of());
                    if (results.isEmpty()) {
                        User user2 = new User();
                        user2.setUsername(profile.getUsername());
                        user2.setRealm(k.getRealm());
                        user2.setUserType(k.getType());
                        user2.setAccessLevel(AccessLevel.USER);
                        Server.userAuthenticationModule.createUser(user2.getUserType(), user2.getRealm(), Server.nameServer, user2);
                        continue;
                    }
                    profile.setId(((User)results.get(0)).getJamiId());
                }
            });
        });
        JsonObject obj = new JsonObject();
        JsonArray profilesArray = this.gson.toJsonTree(this.userProfiles).getAsJsonArray();
        for (int i = 0; i < profilesArray.size(); ++i) {
            JsonObject profile = profilesArray.get(i).getAsJsonObject();
            String usernamerev = profile.get("username").getAsString();
            User user = Server.dataStore.getUserDao().getByUsername(usernamerev).orElse(null);
            if (user == null) continue;
            X509CRLHolder crl = Server.certificateAuthority.getLatestCRL().get();
            if (crl != null) {
                X509CRLEntryHolder revoked = crl.getRevokedCertificate(user.getCertificate().getSerialNumber());
                profile.addProperty("revoked", revoked != null);
                continue;
            }
            profile.addProperty("revoked", false);
        }
        obj.add("profiles", profilesArray);
        obj.addProperty("numPages", DataStore.NUM_PAGES);
        resp.getOutputStream().write(this.gson.toJson(obj).getBytes());
        resp.flushBuffer();
        resp.setStatus(200);
    }
}

