/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.directory;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/auth/directory/entry"})
public class DirectoryEntryServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DirectoryEntryServlet.class);
    private final Gson gson = GsonFactory.createGson();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username;
        String directory = req.getParameter("directory");
        String directoryType = req.getParameter("directoryType");
        String format = req.getParameter("format");
        boolean isInVCardFormat = format != null && format.equals("vcard");
        String jamiId = req.getParameter("jamiId");
        String string = username = jamiId != null ? Server.dataStore.getUserDao().getByJamiId(jamiId).get(0).getUsername() : req.getParameter("username");
        if (directory != null && directoryType != null) {
            AuthModuleKey authModuleKey = new AuthModuleKey(directory, AuthenticationSourceType.fromString(directoryType));
            List<UserProfile> userProfiles = Server.userAuthenticationModule.getAuthSources().get(authModuleKey).searchUserProfiles(username, "LOGON_NAME", Optional.empty());
            UserProfile userProfile = userProfiles.get(0);
            String result = isInVCardFormat ? userProfile.getAsVCard() : this.gson.toJson(userProfile);
            resp.getOutputStream().write(result.getBytes());
            resp.flushBuffer();
            return;
        }
        ArrayList userProfiles = new ArrayList();
        Server.userAuthenticationModule.getAuthSources().values().forEach(v -> userProfiles.addAll(v.searchUserProfiles(username, "LOGON_NAME", Optional.empty())));
        UserProfile userProfile = (UserProfile)userProfiles.get(0);
        String result = isInVCardFormat ? userProfile.getAsVCard() : this.gson.toJson(userProfile);
        resp.getOutputStream().write(result.getBytes());
        resp.flushBuffer();
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }
}

