/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.conversations;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.jami.jams.common.objects.conversations.Conversation;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.common.utils.ConversationMerger;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/auth/conversations"})
public class ConversationServlet
extends HttpServlet {
    private static final Gson gson = GsonFactory.createGson();

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String owner = req.getAttribute("username").toString();
        ConversationServlet.addConversations(req, resp, owner);
    }

    public static void addConversations(HttpServletRequest req, HttpServletResponse resp, String owner) throws IOException {
        List<Conversation> remoteList = Arrays.asList(gson.fromJson((Reader)req.getReader(), Conversation[].class));
        List<Conversation> localList = Server.dataStore.getConversationDao().getByOwner(owner);
        remoteList.forEach(conversation -> conversation.setOwner(owner));
        List<Conversation> result = ConversationMerger.mergeConversations(localList, remoteList);
        if (result.size() > 0 && !Server.dataStore.getConversationDao().storeConversationList(result)) {
            TomcatCustomErrorHandler.sendCustomError(resp, 500, "Unable to store conversations!");
        } else {
            resp.getOutputStream().write(gson.toJson(result).getBytes());
            resp.flushBuffer();
        }
    }
}

