/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/groups"})
public class GroupsServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GroupsServlet.class);
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        List<Group> groups = Server.dataStore.getGroupDao().getAll();
        resp.getOutputStream().write(this.gson.toJson(groups).getBytes());
        resp.flushBuffer();
        resp.setStatus(200);
    }
}

