/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/group/*"})
public class GroupServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GroupServlet.class);
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String id = req.getPathInfo().replace("/", "");
        Optional<Group> singleGroup = Server.dataStore.getGroupDao().getById(id);
        if (singleGroup.isPresent()) {
            resp.getOutputStream().write(this.gson.toJson(singleGroup.orElseThrow()).getBytes());
            resp.flushBuffer();
            resp.setStatus(200);
        } else {
            log.info("No group with this id was found!");
            resp.setStatus(404);
        }
    }

    @Override
    @JsonContent
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String id = req.getPathInfo().replace("/", "");
        JsonObject obj = this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
        String name = obj.get("name").getAsString();
        String blueprint = obj.get("blueprint").getAsString();
        if (Server.dataStore.getGroupDao().updateObject(id, name, blueprint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "An error occurred while attempting to update the group.");
        }
    }

    @Override
    @JsonContent
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String groupId = req.getPathInfo().replace("/", "");
        if (Server.dataStore.getGroupDao().deleteObject(groupId)) {
            if (Server.dataStore.getUserGroupMappingsDao().deleteObject("*", groupId)) {
                resp.setStatus(200);
            } else {
                resp.sendError(500, "An error occurred while attempting to delete the group mappings.");
            }
        } else {
            resp.sendError(500, "An error occurred while attempting to delete the group.");
        }
    }
}

