/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.directory;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/directory/entry"})
public class DirectoryEntryServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DirectoryEntryServlet.class);
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String realm = "LOCAL";
        UserProfile userProfile = this.gson.fromJson((Reader)req.getReader(), UserProfile.class);
        Server.userAuthenticationModule.getAuthSources().get(new AuthModuleKey(realm, AuthenticationSourceType.LOCAL)).setUserProfile(userProfile);
        resp.setStatus(200);
        HashMap<String, String> profileName = new HashMap<String, String>();
        profileName.put("username", userProfile.getUsername());
        resp.getOutputStream().write(this.gson.toJson(profileName).getBytes());
        resp.flushBuffer();
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException, SecurityException {
        UserProfile userProfile = this.gson.fromJson((Reader)req.getReader(), UserProfile.class);
        String username = req.getAttribute("username").toString();
        User targetUser = Server.dataStore.getUserDao().getByUsername(userProfile.getUsername()).orElseThrow();
        User callingUser = Server.dataStore.getUserDao().getByUsername(username).orElseThrow();
        if (targetUser.getUserType() != AuthenticationSourceType.LOCAL) {
            resp.sendError(403, "The user is not a local user, therefore we are unable to change his data!");
            return;
        }
        if (callingUser.getAccessLevel() == AccessLevel.ADMIN || callingUser.getAccessLevel() == AccessLevel.USER && callingUser.getUsername().equals(targetUser.getUsername())) {
            if (Server.dataStore.updateUserProfile(userProfile)) {
                resp.setStatus(200);
            } else {
                resp.sendError(500, "Unable to update the user's profile information");
            }
            return;
        }
        resp.sendError(403, "The user is either not an admin account or is attempting to edit a profile that is not his own!");
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
    }
}

