/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.devices;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/admin/devices"})
public class DevicesServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        List<Device> devices = Server.dataStore.getDeviceDao().getByOwner(username);
        if (Server.certificateAuthority.getLatestCRL() != null) {
            devices.forEach(device -> device.setRevoked(Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(device.getCertificate().getSerialNumber()) != null));
        } else {
            devices.forEach(device -> device.setRevoked(false));
        }
        resp.getOutputStream().write(this.gson.toJson(devices).getBytes());
        resp.flushBuffer();
    }
}

