/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.licensing;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import net.jami.jams.common.updater.subscription.LicenseInformation;
import net.jami.jams.common.utils.X509Utils;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseService.class);
    private X509Certificate certificate;
    private PrivateKey privateKey;
    private X509Certificate caCertificate;
    private LicenseInformation licenseInformation = new LicenseInformation();

    public void loadLicense() {
        try {
            Path path = Path.of(System.getProperty("user.dir") + File.separator + "license.dat", new String[0]);
            Vector<Object> v = X509Utils.loadLicenseFromDatFile(new String(Files.readAllBytes(path)));
            this.certificate = (X509Certificate)v.get(0);
            this.privateKey = (PrivateKey)v.get(1);
            this.caCertificate = X509Utils.getCertificateFromPEMString(new String(LicenseService.class.getClassLoader().getResourceAsStream("oem/ca.crt").readAllBytes()));
            try {
                this.certificate.checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException c2) {
                log.error("Your license is not yet valid or has expired!");
                Server.activated.set(false);
            }
            try {
                this.certificate.verify(this.caCertificate.getPublicKey());
                Server.activated.set(true);
                log.info("Server is activated with valid license: {}", (Object)Server.activated.get());
                Server.appUpdater.setLicense(this.certificate, this.privateKey);
                log.info("License inside updater module set successfully.");
            }
            catch (Exception e) {
                log.error("The license file you have provided was unable to be verified!");
                Server.activated.set(false);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while loading the license.");
            Server.activated.set(false);
        }
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCaCertificate() {
        return this.caCertificate;
    }

    public LicenseInformation getLicenseInformation() {
        return this.licenseInformation;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setCaCertificate(X509Certificate caCertificate) {
        this.caCertificate = caCertificate;
    }

    public void setLicenseInformation(LicenseInformation licenseInformation) {
        this.licenseInformation = licenseInformation;
    }
}

