/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core.workflows;

import java.math.BigInteger;
import net.jami.jams.common.objects.requests.RevocationRequest;
import net.jami.jams.common.objects.requests.RevocationType;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeUserFlow {
    private static final Logger log = LoggerFactory.getLogger(RevokeUserFlow.class);

    public static DeviceRevocationResponse revokeUser(String username) {
        DeviceRevocationResponse response = new DeviceRevocationResponse();
        try {
            User user = Server.dataStore.getUserDao().getByUsername(username).get();
            if (user == null) {
                log.error("Unable to find user!");
                return null;
            }
            BigInteger serialNumber = user.getCertificate().getSerialNumber();
            RevocationRequest request = new RevocationRequest();
            request.setRevocationType(RevocationType.USER);
            request.setIdentifier(serialNumber);
            Server.certificateAuthority.revokeCertificate(request);
            Server.certificateAuthority.waitForRevokeCompletion();
            if (Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(serialNumber) != null) {
                response.setSuccess(true);
                return response;
            }
            log.error("The certificate has not appeared in the CRL. Operation may have failed.");
            response.setSuccess(false);
            return response;
        }
        catch (Exception e) {
            log.error("An error occurred while revoking device: {}", (Object)e.getMessage());
            response.setSuccess(false);
            response.setErrorDetails(e.getMessage());
            return response;
        }
    }
}

