/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.TomcatConnectorFactory;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.JarResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatLauncher {
    private static final Logger log = LoggerFactory.getLogger(TomcatLauncher.class);
    private final Tomcat tomcat = new Tomcat();
    private StandardContext context;

    public TomcatLauncher(int port) {
        this.tomcat.getService().addConnector(TomcatConnectorFactory.getNoSSLConnector(port));
        this.startServer();
    }

    public void swapConnectors() {
        if (this.getTomcat().getConnector().findSslHostConfigs() != null && this.getTomcat().getConnector().findSslHostConfigs().length > 0) {
            this.getTomcat().getConnector().findSslHostConfigs()[0].setTruststoreFile(System.getProperty("user.dir") + File.separator + "keystore.jks");
            this.getTomcat().getConnector().findSslHostConfigs()[0].setTruststorePassword("changeit");
            this.getTomcat().getConnector().findSslHostConfigs()[0].setCertificateVerification("optional");
            ((Http11NioProtocol)this.getTomcat().getConnector().getProtocolHandler()).reloadSslHostConfigs();
        } else {
            log.error("Unable to reload SSL configuration because the server is not running over SSL!");
        }
    }

    public TomcatLauncher(int port, String certificateFile, String keyFile) {
        if (!Files.exists(Paths.get(System.getProperty("user.dir") + File.separator + certificateFile, new String[0]), new LinkOption[0]) || !Files.exists(Paths.get(System.getProperty("user.dir") + File.separator + keyFile, new String[0]), new LinkOption[0])) {
            log.info("Unable to find certificate or keyfile, exiting");
            System.exit(1);
        }
        if (Files.exists(Paths.get(System.getProperty("user.dir") + File.separator + "keystore.jks", new String[0]), new LinkOption[0])) {
            log.info("Found a valid trust store, injecting into tomcat!");
            this.tomcat.getService().addConnector(TomcatConnectorFactory.getSSLConnectorWithTrustStore(certificateFile, keyFile, port));
        } else {
            Connector connector = TomcatConnectorFactory.getSSLConnectorWithoutTrustStore(certificateFile, keyFile, port);
            this.tomcat.getService().addConnector(connector);
        }
        this.startServer();
    }

    public void startServer() {
        String jarName = System.getProperty("user.dir") + File.separator + "jams-server.jar";
        log.info("JAR Resource File = " + jarName);
        String contextPath = new File(System.getProperty("user.dir")).getAbsolutePath() + File.separator + "app";
        try {
            Path path = Paths.get(contextPath, new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Exception e) {
            log.error("Unable to create context directory", e);
        }
        this.context = (StandardContext)this.tomcat.addWebapp("", contextPath);
        this.context.getJarScanner().setJarScanFilter((jarScanType, s) -> false);
        log.info("Serving application from: " + contextPath);
        StandardRoot resources = new StandardRoot(this.context);
        if (jarName.contains(".jar")) {
            resources.addPreResources(new JarResourceSet(resources, "/WEB-INF/classes", jarName, "/net/jami/jams/server/servlets"));
            resources.addPreResources(new JarResourceSet(resources, "/", jarName, "/webapp"));
        } else {
            log.info("WARNING: You are running from your local filesystem, this makes sense only for developers!");
            StringBuilder basePath = new StringBuilder();
            String[] paths = System.getProperty("user.dir").split("/");
            for (int i = 0; i < paths.length - 1; ++i) {
                basePath.append("/").append(paths[i]);
            }
            basePath.append("/jams-server");
            resources.addPreResources(new DirResourceSet(resources, "/WEB-INF/classes", basePath + "/target/classes/net/jami/jams/server/servlets", "/"));
            resources.addPreResources(new DirResourceSet(resources, "/", basePath + "/target/classes", "/webapp"));
        }
        this.context.setResources(resources);
        this.context.addWelcomeFile("index");
        ErrorPage notFound = new ErrorPage();
        notFound.setErrorCode(404);
        notFound.setLocation("/");
        ErrorPage genericError = new ErrorPage();
        genericError.setErrorCode(500);
        genericError.setLocation("/500");
        this.context.addErrorPage(notFound);
        this.context.addErrorPage(genericError);
        try {
            this.tomcat.start();
        }
        catch (Exception e) {
            log.error("An error occurred while attempting to start Web server.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTomcat() {
        try {
            Tomcat tomcat = this.tomcat;
            synchronized (tomcat) {
                Server.certificateAuthority.shutdownThreads();
                this.tomcat.stop();
                this.context.destroy();
                this.tomcat.destroy();
            }
        }
        catch (Exception e) {
            log.info("An error occurred while attempting to stop Tomcat server: {}", (Object)e.getMessage());
        }
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public StandardContext getContext() {
        return this.context;
    }
}

