/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.dht.hashutils;

import net.jami.jams.dht.hashutils.DigestEngine;

abstract class MDHelper
extends DigestEngine {
    private final boolean littleEndian;
    private final byte[] countBuf;
    private final byte fbyte;

    MDHelper(boolean littleEndian, int lenlen) {
        this(littleEndian, lenlen, -128);
    }

    MDHelper(boolean littleEndian, int lenlen, byte fbyte) {
        this.littleEndian = littleEndian;
        this.countBuf = new byte[lenlen];
        this.fbyte = fbyte;
    }

    protected void makeMDPadding() {
        int dataLen = this.flush();
        int blen = this.getBlockLength();
        long currentLength = this.getBlockCount() * (long)blen;
        currentLength = (currentLength + (long)dataLen) * 8L;
        int lenlen = this.countBuf.length;
        if (this.littleEndian) {
            MDHelper.encodeLEInt((int)currentLength, this.countBuf, 0);
            MDHelper.encodeLEInt((int)(currentLength >>> 32), this.countBuf, 4);
        } else {
            MDHelper.encodeBEInt((int)(currentLength >>> 32), this.countBuf, lenlen - 8);
            MDHelper.encodeBEInt((int)currentLength, this.countBuf, lenlen - 4);
        }
        int endLen = dataLen + lenlen + blen & ~(blen - 1);
        this.update(this.fbyte);
        for (int i = dataLen + 1; i < endLen - lenlen; ++i) {
            this.update((byte)0);
        }
        this.update(this.countBuf);
    }

    private static final void encodeLEInt(int val2, byte[] buf, int off) {
        buf[off] = (byte)val2;
        buf[off + 1] = (byte)(val2 >>> 8);
        buf[off + 2] = (byte)(val2 >>> 16);
        buf[off + 3] = (byte)(val2 >>> 24);
    }

    private static final void encodeBEInt(int val2, byte[] buf, int off) {
        buf[off] = (byte)(val2 >>> 24);
        buf[off + 1] = (byte)(val2 >>> 16);
        buf[off + 2] = (byte)(val2 >>> 8);
        buf[off + 3] = (byte)val2;
    }
}

