/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.security.PrivateKey;
import net.jami.jams.common.utils.X509Utils;

public class PrivateKeyAdapter
implements JsonSerializer<PrivateKey>,
JsonDeserializer<PrivateKey> {
    @Override
    public PrivateKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return X509Utils.getKeyFromPEMString(json.getAsString());
    }

    @Override
    public JsonElement serialize(PrivateKey src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(X509Utils.getPEMStringFromPrivateKey(src));
    }
}

