/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.jami.jams.common.objects.conversations.ConversationRequest;

public class ConversationRequestAdapter
implements JsonSerializer<ConversationRequest>,
JsonDeserializer<ConversationRequest> {
    @Override
    public ConversationRequest deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new Gson();
        JsonObject input = json.getAsJsonObject();
        ConversationRequest conversationRequest = new ConversationRequest();
        conversationRequest.setConversationId(input.get("conversationId").getAsString());
        conversationRequest.setSender(input.get("from").getAsString());
        conversationRequest.setMetadatas(gson.toJson(input.get("metadatas")));
        long timeReceived = 0L;
        if (input.has("received")) {
            timeReceived = input.get("received").getAsLong();
        }
        conversationRequest.setReceived(timeReceived);
        long timeDeclined = 0L;
        if (input.has("timeDeclined")) {
            timeDeclined = input.get("timeDeclined").getAsLong();
        }
        conversationRequest.setDeclined(timeDeclined);
        return conversationRequest;
    }

    @Override
    public JsonElement serialize(ConversationRequest conversationRequest, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject output = new JsonObject();
        output.addProperty("conversationId", conversationRequest.getConversationId());
        output.addProperty("from", conversationRequest.getSender());
        JsonElement jsonMetadatas = JsonParser.parseString(conversationRequest.getMetadatas());
        output.add("metadatas", jsonMetadatas);
        output.addProperty("received", conversationRequest.getReceived());
        output.addProperty("declined", conversationRequest.getDeclined());
        return output;
    }
}

