/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.objects.responses;

import com.google.gson.Gson;
import java.security.cert.X509Certificate;
import net.jami.jams.common.objects.user.PolicyData;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.utils.X509Utils;

public class DeviceRegistrationResponse {
    private String certificateChain;
    private String displayName;
    private String nameServer;
    private String deviceReceipt;
    private String receiptSignature;
    private String userPhoto;
    private Boolean publicInCalls;
    private Boolean proxyEnabled;
    private String dhtProxyListUrl;
    private String proxyServer;
    private Boolean accountPublish;
    private Boolean autoAnswer;
    private String turnServer;
    private String turnServerUserName;
    private String turnServerPassword;
    private Boolean videoEnabled;
    private Boolean turnEnabled;
    private Boolean accountDiscovery;
    private Boolean peerDiscovery;
    private Boolean upnpEnabled;
    private Boolean rendezVous;
    private String defaultModerators;
    private String uiCustomization;

    public void setCertificateChain(X509Certificate[] certificateChain) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = certificateChain.length - 1; i > -1; --i) {
            stringBuilder.append(X509Utils.getPEMStringFromCertificate(certificateChain[i])).append("\n");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.certificateChain = stringBuilder.toString();
    }

    public void setPolicyData(String policyData) {
        Gson gson = GsonFactory.createGson();
        PolicyData policy = gson.fromJson(policyData, PolicyData.class);
        this.publicInCalls = policy.getPublicInCalls();
        this.proxyEnabled = policy.getProxyEnabled();
        this.dhtProxyListUrl = policy.getDhtProxyListUrl();
        this.proxyServer = policy.getProxyServer();
        this.accountPublish = policy.getAccountPublish();
        this.autoAnswer = policy.getAutoAnswer();
        this.turnServer = policy.getTurnServer();
        this.turnServerUserName = policy.getTurnServerUserName();
        this.turnServerPassword = policy.getTurnServerPassword();
        this.videoEnabled = policy.getVideoEnabled();
        this.turnEnabled = policy.getTurnEnabled();
        this.accountDiscovery = policy.getAccountDiscovery();
        this.peerDiscovery = policy.getPeerDiscovery();
        this.upnpEnabled = policy.getUpnpEnabled();
        this.rendezVous = policy.getRendezVous();
        this.defaultModerators = policy.getDefaultModerators();
        this.uiCustomization = policy.getUiCustomization();
    }

    public String getCertificateChain() {
        return this.certificateChain;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public String getDeviceReceipt() {
        return this.deviceReceipt;
    }

    public String getReceiptSignature() {
        return this.receiptSignature;
    }

    public String getUserPhoto() {
        return this.userPhoto;
    }

    public Boolean getPublicInCalls() {
        return this.publicInCalls;
    }

    public Boolean getProxyEnabled() {
        return this.proxyEnabled;
    }

    public String getDhtProxyListUrl() {
        return this.dhtProxyListUrl;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public Boolean getAccountPublish() {
        return this.accountPublish;
    }

    public Boolean getAutoAnswer() {
        return this.autoAnswer;
    }

    public String getTurnServer() {
        return this.turnServer;
    }

    public String getTurnServerUserName() {
        return this.turnServerUserName;
    }

    public String getTurnServerPassword() {
        return this.turnServerPassword;
    }

    public Boolean getVideoEnabled() {
        return this.videoEnabled;
    }

    public Boolean getTurnEnabled() {
        return this.turnEnabled;
    }

    public Boolean getAccountDiscovery() {
        return this.accountDiscovery;
    }

    public Boolean getPeerDiscovery() {
        return this.peerDiscovery;
    }

    public Boolean getUpnpEnabled() {
        return this.upnpEnabled;
    }

    public Boolean getRendezVous() {
        return this.rendezVous;
    }

    public String getDefaultModerators() {
        return this.defaultModerators;
    }

    public String getUiCustomization() {
        return this.uiCustomization;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public void setDeviceReceipt(String deviceReceipt) {
        this.deviceReceipt = deviceReceipt;
    }

    public void setReceiptSignature(String receiptSignature) {
        this.receiptSignature = receiptSignature;
    }

    public void setUserPhoto(String userPhoto) {
        this.userPhoto = userPhoto;
    }

    public void setPublicInCalls(Boolean publicInCalls) {
        this.publicInCalls = publicInCalls;
    }

    public void setProxyEnabled(Boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public void setDhtProxyListUrl(String dhtProxyListUrl) {
        this.dhtProxyListUrl = dhtProxyListUrl;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public void setAccountPublish(Boolean accountPublish) {
        this.accountPublish = accountPublish;
    }

    public void setAutoAnswer(Boolean autoAnswer) {
        this.autoAnswer = autoAnswer;
    }

    public void setTurnServer(String turnServer) {
        this.turnServer = turnServer;
    }

    public void setTurnServerUserName(String turnServerUserName) {
        this.turnServerUserName = turnServerUserName;
    }

    public void setTurnServerPassword(String turnServerPassword) {
        this.turnServerPassword = turnServerPassword;
    }

    public void setVideoEnabled(Boolean videoEnabled) {
        this.videoEnabled = videoEnabled;
    }

    public void setTurnEnabled(Boolean turnEnabled) {
        this.turnEnabled = turnEnabled;
    }

    public void setAccountDiscovery(Boolean accountDiscovery) {
        this.accountDiscovery = accountDiscovery;
    }

    public void setPeerDiscovery(Boolean peerDiscovery) {
        this.peerDiscovery = peerDiscovery;
    }

    public void setUpnpEnabled(Boolean upnpEnabled) {
        this.upnpEnabled = upnpEnabled;
    }

    public void setRendezVous(Boolean rendezVous) {
        this.rendezVous = rendezVous;
    }

    public void setDefaultModerators(String defaultModerators) {
        this.defaultModerators = defaultModerators;
    }

    public void setUiCustomization(String uiCustomization) {
        this.uiCustomization = uiCustomization;
    }
}

