/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.dao.connectivity;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    private static final int MAX_POOL_SIZE = 15;
    private volatile ConcurrentLinkedQueue<SQLConnection> connectionPool = new ConcurrentLinkedQueue();
    private volatile ConcurrentLinkedQueue<SQLConnection> usedConnections = new ConcurrentLinkedQueue();
    private final String connectionURI;

    public ConnectionPool(String connectionURI) {
        this.connectionURI = connectionURI;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            while (this.connectionPool.size() < 15) {
                try {
                    this.connectionPool.add(this.createConnection(this.connectionURI));
                }
                catch (Exception e) {
                    log.error("An error occurred while creating a link with the database: ", e);
                }
            }
        }
        catch (Exception e) {
            log.error("An error occurred while loading ApacheDerby class driver: ", e);
        }
    }

    public synchronized SQLConnection getConnection() {
        try {
            SQLConnection connection;
            if (this.connectionPool.isEmpty()) {
                if (this.usedConnections.size() < 15) {
                    this.connectionPool.add(this.createConnection(this.connectionURI));
                } else {
                    throw new RuntimeException("Maximum pool size reached, no available connections!");
                }
            }
            if ((connection = this.connectionPool.poll()).isStale()) {
                connection.getConnection().close();
                connection = this.createConnection(this.connectionURI);
            }
            connection.getConnection().setAutoCommit(true);
            this.usedConnections.add(connection);
            return connection;
        }
        catch (Exception e) {
            log.error("A connection error occurred: ", e);
            return null;
        }
    }

    public boolean returnConnection(SQLConnection sqlConnection) {
        this.connectionPool.add(sqlConnection);
        return this.usedConnections.remove(sqlConnection);
    }

    private SQLConnection createConnection(String connectionURI) throws SQLException {
        return new SQLConnection(DriverManager.getConnection(connectionURI));
    }
}

