/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.cryptoengineapi.ocsp;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.security.auth.x500.X500Principal;
import net.jami.jams.common.cryptoengineapi.ocsp.CertificateStatus;
import net.jami.jams.common.cryptoengineapi.ocsp.RevocationReason;

public class CertificateSummary {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMddHHmmssZ");
    private final CertificateStatus status;
    private final LocalDateTime expirationTime;
    private final LocalDateTime revocationTime;
    private final RevocationReason revocationReason;
    private final BigInteger serialNumber;
    private final String fileName;
    private final X500Principal subjectDN;
    private final LocalDateTime thisUpdateTime;

    public CertificateStatus getStatus() {
        return this.status;
    }

    public LocalDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public LocalDateTime getRevocationTime() {
        return this.revocationTime;
    }

    public RevocationReason getRevocationReason() {
        return this.revocationReason;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public X500Principal getSubjectDN() {
        return this.subjectDN;
    }

    public LocalDateTime getThisUpdateTime() {
        return this.thisUpdateTime;
    }

    private CertificateSummary(Builder builder) {
        this.status = builder.status;
        this.expirationTime = builder.expirationTime;
        this.revocationTime = builder.revocationTime;
        this.revocationReason = builder.revocationReason;
        this.serialNumber = builder.serialNumber;
        this.fileName = builder.fileName;
        this.subjectDN = builder.subjectDN;
        this.thisUpdateTime = builder.thisUpdateTime == null ? LocalDateTime.now() : builder.thisUpdateTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CertificateSummary(CertificateStatus status, LocalDateTime expirationTime, LocalDateTime revocationTime, RevocationReason revocationReason, BigInteger serialNumber, String fileName, X500Principal subjectDN, LocalDateTime thisUpdateTime) {
        this.status = status;
        this.expirationTime = expirationTime;
        this.revocationTime = revocationTime;
        this.revocationReason = revocationReason;
        this.serialNumber = serialNumber;
        this.fileName = fileName;
        this.subjectDN = subjectDN;
        this.thisUpdateTime = thisUpdateTime;
    }

    public static final class Builder {
        private CertificateStatus status = CertificateStatus.UNKNOWN;
        private LocalDateTime expirationTime = null;
        private LocalDateTime revocationTime = null;
        private RevocationReason revocationReason = null;
        private BigInteger serialNumber = null;
        private String fileName = null;
        private X500Principal subjectDN = null;
        private LocalDateTime thisUpdateTime = null;

        private Builder() {
        }

        public Builder withStatus(CertificateStatus val2) {
            this.status = val2;
            return this;
        }

        public Builder withExpirationTime(LocalDateTime val2) {
            this.expirationTime = val2;
            return this;
        }

        public Builder withRevocationTime(LocalDateTime val2) {
            this.revocationTime = val2;
            return this;
        }

        public Builder withRevocationReason(RevocationReason val2) {
            this.revocationReason = val2;
            return this;
        }

        public Builder withSerialNumber(BigInteger val2) {
            this.serialNumber = val2;
            return this;
        }

        public Builder withFileName(String val2) {
            this.fileName = val2;
            return this;
        }

        public Builder withSubjectDN(X500Principal val2) {
            this.subjectDN = val2;
            return this;
        }

        public Builder withThisUpdateTime(LocalDateTime val2) {
            this.thisUpdateTime = val2;
            return this;
        }

        public CertificateSummary build() {
            return new CertificateSummary(this);
        }
    }
}

