/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.annotations;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import net.jami.jams.common.annotations.ScopedServletMethod;
import net.jami.jams.common.objects.user.AccessLevel;

@SupportedAnnotationTypes(value={"net.jami.jams.common.annotations.ScopedServletMethod"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@SupportedOptions(value={"moduleDir", "parentDir"})
public class ScopedServletProcessor
extends AbstractProcessor {
    private String moduleDirectory = null;
    private String parentDirectory = null;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.moduleDirectory = this.processingEnv.getOptions().get("moduleDir");
        this.parentDirectory = this.processingEnv.getOptions().get("parentDir");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Project Directory: " + this.moduleDirectory);
        if (roundEnv.processingOver()) {
            return false;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Working in directory: " + System.getProperty("user.dir"));
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(ScopedServletMethod.class);
        HashMap<String, HashMap> annList = new HashMap<String, HashMap>();
        annotatedElements.forEach(element -> {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Found class: " + element.getEnclosingElement().toString());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Found method: " + element);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Found " + element.getAnnotation(ScopedServletMethod.class).securityGroups().length + " groups");
            String clsName = element.getEnclosingElement().toString();
            String mthName = element.toString();
            AccessLevel[] levels = element.getAnnotation(ScopedServletMethod.class).securityGroups();
            annList.putIfAbsent(clsName, new HashMap());
            ((HashMap)annList.get(clsName)).putIfAbsent(mthName, levels);
        });
        annList.forEach(this::processClass);
        return true;
    }

    private void processClass(String classname, HashMap<String, AccessLevel[]> methodNames) {
        try {
            URL cpUrl1 = new URL("jar:file:" + this.parentDirectory + File.separator + "compile-libs/tomcat-embed-core-10.1.19.jar!/");
            URL cpUrl3 = new URL("jar:file:" + this.parentDirectory + File.separator + "compile-libs/tomcat-annotations-api-10.1.19.jar!/");
            URLClassLoader cpUrlLoader = new URLClassLoader(new URL[]{cpUrl1, cpUrl3});
            StringBuilder path = new StringBuilder();
            path.append(this.moduleDirectory);
            path.append(File.separator);
            path.append("target");
            path.append(File.separator);
            path.append("classes");
            path.append(File.separator);
            path.append(classname.replaceAll("\\.", File.separator));
            path.append(".class");
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Now processing: " + path);
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath(new LoaderClassPath(cpUrlLoader));
            pool.makeClass(new FileInputStream(this.parentDirectory + "/jams-common/target/classes/net/jami/jams/common/objects/user/AccessLevel.class"));
            pool.makeClass(new FileInputStream(this.parentDirectory + "/jams-common/target/classes/net/jami/jams/common/serialization/tomcat/TomcatCustomErrorHandler.class"));
            CtClass ctClass = pool.makeClass(new FileInputStream(path.toString()));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, ctClass.getName());
            for (String rawmethodName : methodNames.keySet()) {
                String methodName = rawmethodName.split("\\(")[0];
                for (int i = 0; i < ctClass.getMethods().length; ++i) {
                    CtMethod method = ctClass.getMethods()[i];
                    if (!method.getName().equals(methodName)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("{\n");
                    sb.append("boolean allowed = false;\n");
                    sb.append("net.jami.jams.common.objects.user.AccessLevel level = (net.jami.jams.common.objects.user.AccessLevel) req.getAttribute(\"accessLevel\");\n");
                    for (int j = 0; j < methodNames.get(rawmethodName).length; ++j) {
                        sb.append("if(level == net.jami.jams.common.objects.user.AccessLevel.valueOf(\"").append(methodNames.get(rawmethodName)[j].toString()).append("\")) allowed = true;\n");
                    }
                    sb.append("if(!allowed){\n");
                    sb.append("net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler.sendCustomError(resp,403,\"You do not have sufficient permissions to access this resource!\");\n");
                    sb.append("return;\n");
                    sb.append("}\n");
                    sb.append("}\n");
                    ctClass.getMethods()[i].insertBefore(sb.toString());
                }
            }
            path = new StringBuilder();
            path.append(this.moduleDirectory);
            path.append(File.separator);
            path.append("target");
            path.append(File.separator);
            path.append("generated-sources");
            ctClass.writeFile(path.toString());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Saved the class...");
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }
}

