/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca.workers.csr.builders;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.ca.workers.csr.utils.CertificateSigner;
import net.jami.jams.ca.workers.csr.utils.ExtensionLibrary;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.user.User;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceBuilder {
    private static final Logger log = LoggerFactory.getLogger(DeviceBuilder.class);
    private static final ASN1ObjectIdentifier DEVICE_ID_FIELD = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
    private static final ASN1ObjectIdentifier DEVICE_CN = new ASN1ObjectIdentifier("2.5.4.3");

    public static Device generateDevice(User user, Device device) {
        try {
            long now = System.currentTimeMillis();
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(new JcaX509CertificateHolder(user.getCertificate()).getSubject(), new BigInteger(256, new SecureRandom()), new Date(now - 43200000L), new Date(now + JamsCA.deviceLifetime), device.getCertificationRequest().getSubject(), device.getCertificationRequest().getSubjectPublicKeyInfo());
            AccessDescription accessDescription = new AccessDescription(AccessDescription.id_ad_ocsp, new GeneralName(6, JamsCA.serverDomain + "/api/ocsp/" + user.getJamiId()));
            ExtensionLibrary.deviceExtensions.getExtensions().set(3, new Object[]{Extension.authorityInfoAccess, false, new AuthorityInformationAccess(accessDescription)});
            device.setCertificate(CertificateSigner.signCertificate(user.getPrivateKey(), builder, ExtensionLibrary.deviceExtensions));
            device.setCertificationRequest(null);
            return device;
        }
        catch (Exception e) {
            log.error("An error occurred while attempting to generate the user certificate: " + e);
            return null;
        }
    }
}

